// This may look like C code, but it is really -*- C++ -*-
//                         C.Magneville          04/99
#ifndef TMATRIX_SEEN
#define TMATRIX_SEEN

#include "machdefs.h"
#include <stdio.h>
#include <iostream.h>
#include "ppersist.h"
#include "anydataobj.h"
#include "ndatablock.h"

namespace PlanckDPC {

template <class T>
class TMatrix : public AnyDataObj {
public:
  // Creation / destruction 
  TMatrix();
  TMatrix(uint_4 r,uint_4 c);
  TMatrix(uint_4 r,uint_4 c,T* values,Bridge* br=NULL);
  TMatrix(const TMatrix<T>& a);
  TMatrix(const TMatrix<T>& a,bool share);
  virtual ~TMatrix();

  // Gestion taille/Remplissage
  void Clone(const TMatrix<T>& a);
  void Reset(T v=0);
  void Realloc(uint_4 r,uint_4 c,bool force_alloc=true);

  // Informations pointeur/data
  inline int NRows() const {return mNr;}
  inline int NCol()  const {return mNc;}
  T const& operator()(uint_4 r,uint_4 c) const
                     {return *(mNDBlock->Begin()+r*mNc+c);}
  T&       operator()(uint_4 r,uint_4 c)
                     {return *(mNDBlock->Begin()+r*mNc+c);}
  inline       T* Data()       {return mNDBlock->Begin();}
  inline const T* Data() const {return mNDBlock->Begin();}
  inline       NDataBlock<T>* DataBlock()       {return mNDBlock;}
  inline const NDataBlock<T>* DataBlock() const {return mNDBlock;}

  // Operateur d'affectation
  TMatrix<T>& operator = (T x);
  TMatrix<T>& operator = (const TMatrix<T>& a);

  // Impression
  void Print(ostream& os,int lp=0,uint_4 i0=0,uint_4 ni=10,uint_4 j0=0,uint_4 nj=10) const;
  inline void Print(int lp=0,uint_4 i0=0,uint_4 ni=10,uint_4 j0=0,uint_4 nj=10) const
              {Print(cout,lp,i0,ni,j0,nj);}

  // Surcharge d'operateurs
  TMatrix<T>& operator += (T b);
  TMatrix<T>& operator -= (T b);
  TMatrix<T>& operator *= (T b);
  TMatrix<T>& operator /= (T b);

  TMatrix<T>& operator += (const TMatrix<T>& a);
  TMatrix<T>& operator -= (const TMatrix<T>& a);
  TMatrix<T>& operator *= (const TMatrix<T>& a);

protected:
  void Delete(void);

  uint_4 mNr,mNc;
  NDataBlock<T>* mNDBlock;
};

template<class T>
inline ostream& operator << (ostream& os, const TMatrix<T>& a)
                      {a.Print(os); return(os);}

} // Fin du namespace

#endif
