// This may look like C code, but it is really -*- C++ -*-

#ifndef RCPTR_H
#define RCPTR_H

// This implements a very simple "smart pointer" with reference counting.
// Many refinements are possible
//  - implement operator =
//  - const propagation
//  - invasive, when type T has field refcnt, instead of list

// Principle :  use RCPtr<T> instead of T*
// To use with type X, define
//  typedef RCPtr<X> Xp;
//  When creating a new object, use
//    Xp xp = new X(...);
// xp can be used like a X*   xp->field, xp->method(), *xp ...
//    can be passed by reference, copied, etc
// the object is destroyed when the last Xp is destroyed.

#include <list>

template <class T>
class RCPtr {
public:
  RCPtr(T* obj) {
    x = obj;
  }
  
  RCPtr(RCPtr<T> const& other) {
    peers = other.peers;
    x = other.x;
    peers.push_back((RCPtr<T>*)&other);
    for (peerlist::iterator i = peers.begin();
	 i != peers.end(); i++) {
      (*i)->hello(this);
    }
  }
  
  ~RCPtr() {
    for (peerlist::iterator i = peers.begin();
	 i != peers.end(); i++) {
      (*i)->byebye(this);
    }
    if (peers.size() == 0) delete x;
  }

  T* operator->() {return x;}
  T& operator*()  {return *x;}

private:
  typedef list<RCPtr<T>*> peerlist;

  T* x;                  // the object we are referring
  peerlist peers;        // the other smart pointers to the same object

  void hello(RCPtr<T>* newcomer) {
    peers.push_back(newcomer);
  }

  void byebye(RCPtr<T>* dying) {
    peers.remove(dying);
  }
};

#endif
