// This may look like C code, but it is really -*- C++ -*-
//  Classe pour faciliter entree-sortie PPF pour des pointeurs
//  Implementation specifique pour certains type de pointeurs
//       R. Ansari -  Mars 2005

#include "machdefs.h"
#include "sopnamsp.h"
#include "ppftpointerio.h"

//----------------------------------------------------------------------
namespace SOPHYA {
//! \cond
// Specific implementation using table I/O in PPFBinaryIOStreams 
/* DECL_TEMP_SPEC   equivalent a template <> , pour SGI-CC en particulier */
void PPF_TPointer_IO<char>::Write(POutPersist & os, char const * arr, size_t n)
  { os.PutBytes(arr,n); }
void PPF_TPointer_IO<char>::Read(PInPersist & is, char * arr, size_t n)
  { is.GetBytes(arr,n); }

void PPF_TPointer_IO< int_1 >::Write(POutPersist & os, int_1 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< int_1 >::Read(PInPersist & is, int_1 * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< uint_1 >::Write(POutPersist & os, uint_1 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< uint_1 >::Read(PInPersist & is, uint_1 * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< int_2 >::Write(POutPersist & os, int_2 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< int_2 >::Read(PInPersist & is, int_2 * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< uint_2 >::Write(POutPersist & os, uint_2 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< uint_2 >::Read(PInPersist & is, uint_2 * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< int_4 >::Write(POutPersist & os, int_4 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< int_4 >::Read(PInPersist & is, int_4 * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< uint_4 >::Write(POutPersist & os, uint_4 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< uint_4 >::Read(PInPersist & is, uint_4 * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< int_8 >::Write(POutPersist & os,  int_8 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< int_8 >::Read(PInPersist & is, int_8 * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< uint_8 >::Write(POutPersist & os,  uint_8 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< uint_8 >::Read(PInPersist & is, uint_8 * arr, size_t n)
  { is.Get(arr,n); }


void PPF_TPointer_IO< r_4 >::Write(POutPersist & os, r_4 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< r_4 >::Read(PInPersist & is, r_4 * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< r_8 >::Write(POutPersist & os,  r_8 const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< r_8 >::Read(PInPersist & is, r_8 * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< complex<r_4> >::Write(POutPersist & os, complex<r_4> const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< complex<r_4> >::Read(PInPersist & is, complex<r_4> * arr, size_t n)
  { is.Get(arr,n); }

void PPF_TPointer_IO< complex<r_8> >::Write(POutPersist & os, complex<r_8> const * arr, size_t n)
  { os.Put(arr,n); }
void PPF_TPointer_IO< complex<r_8> >::Read(PInPersist & is, complex<r_8> * arr, size_t n)
  { is.Get(arr,n); }

//! \endcond

}  // namespace SOPHYA
/*
#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template PPF_TPointer_IO< char >
#pragma define_template PPF_TPointer_IO< int_1 >
#pragma define_template PPF_TPointer_IO< uint_1 >
#pragma define_template PPF_TPointer_IO< int_2 >
#pragma define_template PPF_TPointer_IO< uint_2 >
#pragma define_template PPF_TPointer_IO< int_4 >
#pragma define_template PPF_TPointer_IO< uint_4 >
#pragma define_template PPF_TPointer_IO< int_8 >
#pragma define_template PPF_TPointer_IO< uint_8 >
#pragma define_template PPF_TPointer_IO< r_4 >
#pragma define_template PPF_TPointer_IO< r_8 >
#pragma define_template PPF_TPointer_IO< complex<r_4> >
#pragma define_template PPF_TPointer_IO< complex<r_8> >
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
template class PPF_TPointer_IO< char >;
template class PPF_TPointer_IO< int_1 >;
template class PPF_TPointer_IO< uint_1 >;
template class PPF_TPointer_IO< int_2 >;
template class PPF_TPointer_IO< uint_2 >;
template class PPF_TPointer_IO< int_4 >;
template class PPF_TPointer_IO< uint_4 >;
template class PPF_TPointer_IO< int_8 >;
template class PPF_TPointer_IO< uint_8 >;
template class PPF_TPointer_IO< r_4 >;
template class PPF_TPointer_IO< r_8 >;
template class PPF_TPointer_IO< complex<r_4> >;
template class PPF_TPointer_IO< complex<r_8> >;
#endif
*/
