// Classe d'initialisation du module NTools

#include "sopnamsp.h"
#include "machdefs.h"
#include "ntoolsinit.h"

#include "poly.h"
#include "generaldata.h"
#include "cimage.h"

#include "tabmath.h"
#include "dates.h"
#include "datime.h"

/*!
   \defgroup NTools NTools module
*/

int NToolsInitiator::FgInit = 0;

/*!
  \class SOPHYA::NToolsInitiator
  \ingroup NTools
  \brief NTools module initializer.

   This module contains various tools for Sophya, in particular numerical algorithms
   such as :
   - Non linear fitting (parameter determination) : GeneralFit , MinZSimplex
   - FFT (FFTServerInterface, FFTPackServer)
   - Spline interpolation
   - Numerical integration and differential equations
   - Date/time manipulation and some usual astronomical quantities (datime.c .h)
*/
NToolsInitiator::NToolsInitiator()
  : TArrayInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules NTools

  //  Objets Poly et Poly2  (pas encore a la norme Sophya::PPersist)
  PPRegister(ObjFileIO<Poly>);
  PPRegister(ObjFileIO<Poly2>);

  // Classe GeneralFitData et son PPersist handler
  PPRegister(ObjFileIO<GeneralFitData>);
  DObjRegister(ObjFileIO<GeneralFitData>, GeneralFitData);

  // Classes Image<T> et leurs  PPersist handler
  PPRegister(FIO_Image<uint_2>);
  DObjRegister(FIO_Image<uint_2>, Image<uint_2>);
  PPRegister(FIO_Image<int_4>);
  DObjRegister(FIO_Image<int_4>, Image<int_4>);
  PPRegister(FIO_Image<int_8>);
  DObjRegister(FIO_Image<int_8>, Image<int_8>);
  PPRegister(FIO_Image<r_4>);
  DObjRegister(FIO_Image<r_4>, Image<r_4>);
  PPRegister(FIO_Image<r_8>);
  DObjRegister(FIO_Image<r_8>, Image<r_8>);


//  TSidSetupLaSilla();    Old-Eros

  gTimeZone = new TimeZone;

  ptabFExp = new TabFExp;

}

NToolsInitiator::~NToolsInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
#ifndef Darwin
static NToolsInitiator ntoolsinit;
#endif

