// Classe d'initialisation du module HiStats 
//                        (Histogram and Statistics)

#include "sopnamsp.h"
#include "machdefs.h"
#include "histinit.h"

#include "histos.h"
#include "histos2.h"
#include "hisprof.h"
#include "histerr.h"
#include "ntuple.h"
#include "xntuple.h"
#include "datatable.h"
#include "swppfdtable.h"

/*!
   \defgroup HiStats HiStats module
   This module contains histograms (1D, 2D) and 
   classes for management of data sets as tables (NTuple, DataTable ...)
*/
 
int HiStatsInitiator::FgInit = 0;

/*!
  \class SOPHYA::HiStatsInitiator
  \ingroup HiStats
  This class performs the initialisation for HiStats module.
  More specifically, it registers PPF handlers for the following classes :
  - Histo
  - HProf
  - HistoErr
  - Histo2D
  - NTuple
  - XNTuple
  - DataTable
  - SwPPFDataTable

  If the system linker/loader handles correctly static object initialisation, there
  is no action required when writing programs. If not, an instance of the class must
  be present before any other operation on the libray classes. 
*/

HiStatsInitiator::HiStatsInitiator()
  : NToolsInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules HiStats
  
  PPRegister(ObjFileIO<Histo>);
  DObjRegister(ObjFileIO<Histo>, Histo);
  PPRegister(ObjFileIO<Histo2D>);
  DObjRegister(ObjFileIO<Histo2D>, Histo2D);
  PPRegister(ObjFileIO<HProf>);
  DObjRegister(ObjFileIO<HProf>, HProf);
  PPRegister(ObjFileIO<HistoErr>);
  DObjRegister(ObjFileIO<HistoErr>, HistoErr);

  PPRegister(ObjFileIO<NTuple>);
  DObjRegister(ObjFileIO<NTuple>, NTuple);
  PPRegister(ObjFileIO<XNTuple>);
  DObjRegister(ObjFileIO<XNTuple>, XNTuple);

  PPRegister(ObjFileIO<BaseDataTable>);
  DObjRegister(ObjFileIO<BaseDataTable>, DataTable);
  DObjRegister(ObjFileIO<BaseDataTable>, SwPPFDataTable);

}

HiStatsInitiator::~HiStatsInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static HiStatsInitiator histatsinit;

