// This may look like C code, but it is really -*- C++ -*-

#ifndef RCPTR_H
#define RCPTR_H

// This implements a very simple "smart pointer" with reference counting.
// Many refinements are possible
//  - implement operator =
//  - const propagation
//  - invasive, when type T has field refcnt, instead of list

// Principle :  use RCPtr<T> instead of T*
// To use with type X, define
//  typedef RCPtr<X> Xp;
//  When creating a new object, use
//    Xp xp = new X(...);
// xp can be used like a X*   xp->field, xp->method(), *xp ...
//    can be passed by reference, copied, etc
// the object is destroyed when the last Xp is destroyed.

template <class T>
class RCPtr {
public:
  RCPtr(T* obj) {
    x = obj;
    cnt = new int;
    *cnt = 1;
  }
  
  RCPtr(RCPtr<T> const& other) {
    x = other.x;
    cnt = other.cnt;
    (*cnt)++;
  }
  
  ~RCPtr() {
    (*cnt)--;
    if (!*cnt) {
      delete x;
      delete cnt;
    }
  }

  T* operator->() {return x;}
  T& operator*()  {return *x;}

private:
  T* x;                  // the object we are referring
  int* cnt;              // how many smart pointers ?
};

#endif
