// This may look like C code, but it is really -*- C++ -*-
// Classe d ajustement pour  piapp
// cmv                            98-99
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef PAWEXECUTOR_H_SEEN
#define PAWEXECUTOR_H_SEEN

#include "machdefs.h"
#include <string>
#include <vector>

#include "anydataobj.h"
#include "piacmd.h"

class PAWExecutor : public CmdExecutor {
public:
              PAWExecutor(PIACmd* piac, PIStdImgApp* app);
  virtual     ~PAWExecutor();
  virtual int Execute(string& keyw, vector<string>& args, string& toks);
  virtual bool  IsThreadable(string const & keyw);

protected:
  void  reset(vector<string>& tokens);
  void  n_plot(vector<string>& tokens);
  void  n_proj(vector<string>& tokens);
  void  n_scan(vector<string>& tokens);
  void  n_read(vector<string>& tokens);
  void  n_merge(vector<string>& tokens);
  void  n_merge_col(vector<string>& tokens);
  void  n_copy(vector<string>& tokens);
  void  h_integ(vector<string>& tokens);
  void  v_integ(vector<string>& tokens);
  void  v_sort(vector<string>& tokens);
  void  h_deriv(vector<string>& tokens);
  void  v_deriv(vector<string>& tokens);
  void  h_rebin(vector<string>& tokens);
  void  h_cadd(vector<string>& tokens);
  void  h_cmult(vector<string>& tokens);
  void  h_oper(vector<string>& tokens);
  void  h_plot_2d(vector<string>& tokens);
  void  h_put_vec(vector<string>& tokens);
  void  h_get_vec(vector<string>& tokens);
  void  h_copy(vector<string>& tokens);
  void  h_set(string dum,vector<string>& tokens);
  void  h_err(vector<string>& tokens);
  int_4 decodepawstring(string tokens,string& nameobj
                       ,string& xexp,string& yexp,string& zexp);
  PIStdImgApp* mApp;
  static uint_4 autoc_counter_;
};

#endif
