#ifndef FITSMANAGER_H
#define FITSMANAGER_H

#include "machdefs.h"
#include <string>
#include "fitsinoutfile.h"

namespace SOPHYA {

class FitsHandlerInterface;

/*! 
  \ingroup FitsIOServer
  \brief Top level FITS I/O operations and handler management.
*/
class FitsManager {
 public:
  static int  RegisterHandler(FitsHandlerInterface * fhi, string & clname);
  static int  ListHandlers();
  static void Write(FitsInOutFile& os, AnyDataObj & o);
  static void Read(FitsInOutFile& os, AnyDataObj & o);
  //  static FitsHandlerInterface * Read(FitsInOutFile& os);
 protected:
  static FitsHandlerInterface* FindHandler(AnyDataObj & o);
};

} // Fin du namespace

#endif

