#ifndef FITSBLKRW_H
#define FITSBLKRW_H

#include "fitsinoutfile.h"

namespace SOPHYA {

/*! 
  \ingroup FitsIOServer
  \brief Template class with static methods for handling bloc data 
  read from / write to fits files
*/

template <class T>
class FitsBlockRW {
public:
//! Write image HDU data to a fits file 
static void WriteImageData(FitsInOutFile& fios, const T * d, size_t sz, 
			   long * fpixel=NULL)
{
  int status = 0;
  long fpix[5] = {1,1,1,1,1};
  if (fpixel == NULL) fpixel = fpix;
  T * ncd = const_cast<T *>(d);
  fits_write_pix(fios.FitsPtr(), FitsTypes::DataType(d[0]), fpixel,
		 sz, ncd, &status);
  if ( status ) {
    fits_report_error(stderr, status);
    char buff[32];
    fits_get_errstatus(status, buff);
    string msg = "FitsBlockRW<T>::WriteImageData() Error: " ;
    msg += buff;
    throw FitsIOException(msg);
  }
}

//! Read image HDU data from a fits file 
static void ReadImageData(FitsInOutFile& fios,  T * d, size_t sz, 
			  long * fpixel=NULL)
{
  int status = 0;
  long fpix[5] = {1,1,1,1,1};
  if (fpixel == NULL) fpixel = fpix;
  int anynul = 0;
  fits_read_pix(fios.FitsPtr(), FitsTypes::DataType(d[0]), fpixel,
		 sz, NULL, d, &anynul, &status);
  if ( status ) {
    fits_report_error(stderr, status);
    char buff[32];
    fits_get_errstatus(status, buff);
    string msg = "FitsBlockRW<T>::ReadImageData() Error: " ;
    msg += buff;
    throw FitsIOException(msg);
  }

}


/*! 
  Write binary/ascii HDU data to a fits file. 
  See cfitsio function fits_write_col() for more detail.
  \param colnum : table column number (starting from 1)
  \param firstrow : the write operation starting row (starting from 1)
  \param firstelem : the firstelem (for vector type columns)
  \param d : pointer to data to be written
  \param sz : number of data elements to be written
*/
static void WriteColumnData(FitsInOutFile& fios, int colnum, long firstrow,
			    long firstelem, const T * d, size_t sz)
{
  int status = 0;
  T * ncd = const_cast<T *>(d);
  fits_write_col(fios.FitsPtr(), FitsTypes::DataType(d[0]), colnum,
		 firstrow, firstelem, sz, ncd, &status);
  if ( status ) {
    fits_report_error(stderr, status);
    char buff[32];
    fits_get_errstatus(status, buff);
    string msg = "FitsBlockRW<T>::WriteColumnData() Error: " ;
    msg += buff;
    throw FitsIOException(msg);
  }
  return;
}

/*! 
  Read binary/ascii HDU data from a fits file. 
  See cfitsio function fits_read_col() for more detail.
  \param colnum : table column number (starting from 1)
  \param firstrow : the read operation starting point (row) (starting from 1)
  \param firstelem : the firstelem (for vector type columns)
  \param d : pointer to data to be written
  \param sz : number of data elements to be read
*/
static void ReadColumnData(FitsInOutFile& fios, int colnum, long firstrow,
			    long firstelem, T * d, size_t sz)
{
  int status = 0;
  int anynul = 0;
  fits_read_col(fios.FitsPtr(), FitsTypes::DataType(d[0]), colnum,
		 firstrow, firstelem, sz, NULL, d, &anynul, &status);
  if ( status ) {
    fits_report_error(stderr, status);
    char buff[32];
    fits_get_errstatus(status, buff);
    string msg = "FitsBlockRW<T>::ReadColumnData() Error: " ;
    msg += buff;
    throw FitsIOException(msg);
  }
  return;
}


};

} // Fin du namespace

#endif
