#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>

#include "sopnamsp.h"
#include "histinit.h"
#include "datatable.h"
#include "fitshdtable.h"

void test_fdtable() ; 

int main(int narg, char *arg[])
{
  SophyaInit();
  try {
    test_fdtable();
  }
  catch(PThrowable exc ) {
    cerr << "tnt-main() , Catched exception: \n" << exc.Msg() << endl;
  }
  catch(std::exception ex) {
    cerr << "tnt-main() , Catched exception ! " << (string)(ex.what()) << endl;
  }
  catch(...) {
    cerr << "tnt-main() , Catched ... ! " << endl;
  }
}


void test_fdtable() 
{
  int NL = 600;
  cout << "======= test_fdtable:  simple DataTable+FITS test ======= " << endl;
  {
    cout << "1/ Creating DataTable / Writing to FITS " << endl;
    DataTable dt(64);
    dt.AddIntegerColumn("line");
    dt.AddDoubleColumn("x");
    dt.AddFloatColumn("f_sin");
    dt.AddDoubleColumn("f_x2");
    MuTyV rec[10];
    cout << " Filling ... (NLines=" << NL << ")" << endl;
    for(int k = 0; k<NL; k++) {
      rec[0] = k;
      double x = M_PI*k/100.;
      double fx = sin(x)*cos(x);
      rec[1] = x+1;
      rec[2] = sin(x);
      rec[3] = x*x;
      dt.AddLine(rec);
    }
    cout << dt;
    cout << " Writing dt to fits file dtable.fits ... " << endl;
    FitsInOutFile fios("!dtable.fits", FitsInOutFile::Fits_Create);
    fios << dt;
    cout << " Writing dt to fits as ASCII table with extname= ASC_DTable ... " << endl;
    fios.SetDef_AscTable();
    fios.SetNextExtensionName("ASC_DTable");
    fios << dt;    
  }
  {
    cout << "2/ Reading DataTable from FITS " << endl;
    FitsInOutFile fios("dtable.fits", FitsInOutFile::Fits_RO);
    cout << fios ;
    fios.MoveToNextHDU();
    DataTable dtr;
    fios >> dtr;
    cout << dtr;
    cout << "2.b/  dtr.LineHeaderToString() dtr.LineToString(k)   : " << endl;
    cout << dtr.LineHeaderToString() ;
    for(int k = 0; k<NL; k+=NL/12) 
      cout << "Line[" << k << "] " << dtr.LineToString(k) << endl ;  
    cout << "2.c/  Reading from ASCII table   " << endl;
    DataTable dtra;
    fios >> dtra;
    cout << dtra;
    
  }
  cout << "============ FIN  test_fdtable ======== ======= " << endl;  
}




