#include "sopnamsp.h"
#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include "math.h"
#include <iostream>
#include <string>

#include <typeinfo>
#include "timing.h"
#include "timestamp.h"
#include "histinit.h"
#include "pexceptions.h"

/*  Programme test de la classe TimeStamp             */
/*  SOPHYA - R. Ansari (LAL)  -   Mars 2005           */

int main(int narg, char* arg[])
{
  cout << " ---- Programme ttimestamp.cc - Test classe TimeStamp --- " << endl;
  int rc = 0;
  try {
      SophyaInit();
//    PPRegister(FIO_SphereECP<r_8>);
//    DObjRegister(FIO_SphereECP<r_8>, SphereECP<r_8>);
    
    InitTim(); 
    cout << " Sizeof(TimeStamp=) " << sizeof(TimeStamp) << endl;
    TimeStamp ts; 
    cout << "ts: Now : " << ts << "(->double: " << (double)ts << " )" << endl; 
    TimeStamp ts2("26/8/1974","14:22:35.65"); 
    cout << "ts2: 26/8/1974 14:22:35.65 : " << ts2  
	 << " double->TimeStamp: " << TimeStamp(ts2.ToDays()) << endl; 
    TimeStamp ts3("01/01/1905","00:00:00"); 
    cout << "ts3: 01/01/1905 , 00:00:00 : " << ts3 << " (double): " 
	 << (double)ts3 << " double->TimeStamp: " << TimeStamp(ts3.ToDays()) << endl; 
    TimeStamp ts4("01/01/1901","03:00:20"); 
    cout << "ts3: 01/01/1901 , 03:00:20 : " << ts4 << " (double): " 
	 << (double)ts4 << " double->TimeStamp: " << TimeStamp(ts4.ToDays()) << endl; 

    TimeStamp ts5("01/12/1899","00:00:00"); 
    cout << "ts5: 01/12/1899 , 00:00:00 : " << ts5 << " (double): " 
	 << (double)ts5 << " double->TimeStamp: " << TimeStamp(ts5.ToDays()) << endl; 
    TimeStamp ts6("01/12/1899","15:30:00"); 
    cout << "ts6: 01/12/1899 , 15:30:00 : " << ts6 << " (double): " 
	 << (double)ts6 << " double->TimeStamp: " << TimeStamp(ts6.ToDays()) << endl; 
    cout << " ts.ToString(bool, bool) test : " << endl;
    cout << " ts.ToString()= " << ts.ToString() << endl;
    cout << " ts.ToString(fgd=true, fgh=false)= " << ts.ToString(true, false) << endl;
    cout << " ts.ToString(fgd=false, fgh=true)= " << ts.ToString(false, true) << endl;

  }
  catch (PThrowable & exc) {
    cerr << " ttimestamp.cc: Catched Exception (PThrowable)" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
    rc = 99;
  }
  catch (std::exception & e) {
    cerr << " ttimestamp.cc: Catched std::xception "  
	 << " - what()= " << e.what() << endl;
    rc = 98;
  }
  catch (...) {
    cerr << " ttimestamp.cc: some other exception (...) was caught ! " << endl;
    rc = 97;
  }
  PrtTim("End ttimestamp " );
  cout << " ---- Programme ttimestamp.cc-  FIN  (Rc=" << rc << ") --- " << endl;
  return rc;
}
