// This may look like C code, but it is really -*- C++ -*-
// Nombres aleatoires pour Peida.
//        C. Magneville   1996-2000
// DAPNIA/SPP (Saclay) / CEA    LAL - IN2P3/CNRS  (Orsay)

#ifndef PERANDOM_SEEN
#define PERANDOM_SEEN

#include "machdefs.h"
#include <stdlib.h>
#include "histos.h"
#include "nbrandom.h"

namespace SOPHYA {  

class FunRan : public Histo {
public:
  typedef r_8 (*Func)(r_8);
  FunRan(Func f, r_8 xMin=0.0, r_8 xMax=1.0, int_4 nBin=100);
  FunRan(r_8 *tab, int_4 nBin);
  FunRan(r_8 *tab, int_4 nBin, r_8 xMin, r_8 xMax);
  FunRan(Histo &h);
  void IFunRan(r_8 *tab, int_4 nBin);
  r_8 Random(void);
  int_4 BinRandom(void);
};

class FunRan2D  {
public:
//  typedef r_8 (*Func)(r_8, r_8);
//  FunRan2D(Func f, r_8 xMin=0.0, r_8 xMax=1.0, int_4 nBinX=100,
//                   r_8 yMin=0.0, r_8 yMax=1.0, int_4 nBinY=100);
  FunRan2D(r_8 *tab, int_4 nBinX, int_4 nBinY);
  FunRan2D(r_8 **tab, int_4 nBinX, int_4 nBinY);
  ~FunRan2D();
  void Random(r_8& x, r_8& y);
  void BinRandom(int_4& x, int_4& y);
private:
  FunRan* ranX;
  FunRan** ranY;
  int_4 nx;
};

} // namespace SOPHYA

#endif
