#include "machdefs.h"
#include "sopnamsp.h"

#include <stdio.h>
#include <string.h>
#include <iostream>
#include <typeinfo>

#include "fitsmanager.h"
#include "fitshandler.h"

struct hand_list_el {
  FitsHandlerInterface * fhi;
  string clname;
};

typedef list<hand_list_el> HandlerList;

static HandlerList * hlistp = NULL;

static inline void ChkHLP() 
{
  if (hlistp == NULL) hlistp = new HandlerList;
}

int FitsManager::RegisterHandler(FitsHandlerInterface * fhi, string & clname)
{
  if (fhi == NULL)
    throw NullPtrError("FitsManager::RegisterHandler() fhi=NULL ");
  HandlerList::iterator it;
  for(it = hlistp->begin(); it != hlistp->end(); it++) {
    if (typeid(*((*it).fhi)) == typeid(*fhi)) 
      throw DuplicateIdExc("FitsManager::RegisterHandler() Already registered handler");
  }
  hand_list_el hle;
  hle.fhi = fhi;
  hle.clname = clname;
  hlistp->push_back(hle);
  return hlistp->size();
}

int FitsManager::ListHandlers()
{
  int kk=0;
  cout << "---- FitsManager::ListHandlers()  NbHandlers= " << hlistp->size()
       << endl;
  HandlerList::iterator it;
  for(it = hlistp->begin(); it != hlistp->end(); it++) {
    kk++;
    cout << kk << "- " << (*it).clname << " : " 
	 << typeid(*((*it).fhi)).name() << endl;
  }
  return hlistp->size();
}

FitsHandlerInterface* FitsManager::FindHandler(AnyDataObj & o)
{
  FitsHandlerInterface * fhi = NULL;
  HandlerList::iterator it;
  for(it = hlistp->begin(); it != hlistp->end(); it++) 
    if ( (*it).fhi->CheckHandling(o) ) {
      fhi = (*it).fhi; break;
    }
  if (fhi == NULL) {
    string msg = "FitsManager::FindHandler() Handler not found for ";
    msg += typeid(o).name();
    throw NotFoundExc(msg);
  }
  else return fhi;
}

void FitsManager::Write(FitsInOutFile& os, AnyDataObj & o)
{
  FitsHandlerInterface * fhi2 = FindHandler(o)->Clone();
  fhi2->SetDataObj(o);
  fhi2->Write(os);
  return;
}

void FitsManager::Read(FitsInOutFile& os, AnyDataObj & o)
{
  FitsHandlerInterface * fhi2 = FindHandler(o)->Clone();
  fhi2->SetDataObj(o);
  fhi2->Read(os);
  return;
}
