// This may look like C code, but it is really -*- C++ -*-
// Gestion de block de donnees swapable
//          C. Magneville R. Ansari  Mai 2005
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA
#ifndef FITSSWAPPER_H
#define FITSSWAPPER_H


#include "machdefs.h"
#include "swsegdb.h"
#include "fitsinoutfile.h"
#include "fitsblkrw.h"

namespace SOPHYA {
/*!
  \class SOPHYA::FITSDataSwapper
  \ingroup FitsIOServer
  Implementation of SOPHYA::DataSwapperInterface interface on FITS files
  (FitsInOutFile) to be used with SOPHYA::SwSegDataBlock classes.
*/

template <class T> 
class FITSDataSwapper : public DataSwapperInterface<T> {
public:
  FITSDataSwapper() 
  {
    SetInOutStream(NULL, 0); 
  }
  FITSDataSwapper(FitsInOutFile * ios, int col) 
  {
    SetInOutStream(ios, col); 
  }

  inline FitsInOutFile * InOutStream() { return fios; }
  void SetInOutStream(FitsInOutFile * ios, int col) 
  {
    fios = ios;
    fcol = col;
    rowos = 1;
    if ( fios != NULL) {
      fhdu = fios->CurrentHDU();
      if (fios->CurrentHDUType() != BINARY_TBL)
	throw FitsIOException("FITSDataSwapper<T>::SetInOutStream() CurrHDU not a BINARY_TBL");
    }
  }

  // Operateur = , on recopie les pointeurs des streams 
  FITSDataSwapper<T>& operator = (FITSDataSwapper<T> const & a)
  {
    fios = a.fios;
    fcol = a.fcol;
    rowos = a.rowos;
    fhdu = a.fhdu;
  }

  virtual int_8 WriteToSwap(const T * d, size_t sz, int_8 idx, int_8 oswp=0, bool osw=false)
  {
    if (fios == NULL) 
      FitsIOException("FITSDataSwapper<T>::ReadFromSwap() null InOutFile pointer");
    fios->MoveAbsToHDU(fhdu);
    long row = rowos;
    if (osw)  row = oswp;
    FitsBlockRW<T>::WriteColumnData(*fios, fcol, row, 1, d, sz);
    if (!osw) rowos += sz;
    return row;
  }

  virtual void  ReadFromSwap(int_8 idx, int_8 swp, T* d, size_t sz)
  {
    if (fios == NULL) 
      FitsIOException("FITSDataSwapper<T>::ReadFromSwap() null InOutFile pointer");
    FitsBlockRW<T>::ReadColumnData(*fios, fcol, swp, 1, d, sz);
  }

protected:
  FitsInOutFile * fios;
  int fcol, fhdu;
  long rowos;
};

} // Fin du namespace

#endif
