#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>

#include "sopnamsp.h"
#include "histinit.h"
#include "dvlist.h"
// #include "datatable.h"
// #include "swppfdtable.h"
#include "fitsswapper.h"

void test_fdtable() ; 

int main(int narg, char *arg[])
{
  SophyaInit();
  try {
    /*
    if (*arg[1] == 'd')  test_dvl();
    else if (*arg[1] == 'n')  test_ntuple();
    //    else if (*arg[1] == 'x')  test_xntuple();
    else if (*arg[1] == 'X')  test_Xntuple();
    */
    test_fdtable();
  }
  catch(PThrowable exc ) {
    cerr << "tswfits-main() , Catched exception: \n" << exc.Msg() << endl;
  }
  catch(std::exception ex) {
    cerr << "tswfits-main() , Catched exception ! " << (string)(ex.what()) << endl;
  }
  catch(...) {
    cerr << "tswfits-main() , Catched ... ! " << endl;
  }
}


void test_fdtable() 
{
  cout << "======= test_fdtable:  simple DataTable+FITS test ======= " << endl;
    int SWSEGSZ = 4;
    vector<int_8> tags;
    {
      cout << " Creation FITSDataSwapper<double> swout(so) avec swseg.fits " << endl;
      vector<string> ttype, tform, tunit;
      ttype.push_back("D-Col1");
      tform.push_back("D");
      tunit.push_back("");
      //      ttype.push_back("I-Col2");
      //      tform.push_back("J");
      //      tunit.push_back("");
      string tblnm = "SwapMyExt";
      FitsInOutFile fiosc("!swseg.fits", FitsInOutFile::Fits_Create);
      //      fiosc.MoveAbsToHDU(2);
      cout << " DBG-Appel CreateTable ... " << endl;
      fiosc.CreateTable(BINARY_TBL, "rzbintbl", ttype, tform, tunit);
      cout << " ---- Appel a FITSDataSwapper<double> --- " << endl;
      FITSDataSwapper<double> swout(&fiosc, 1);
      SwSegDataBlock<double> swsd(swout, SWSEGSZ, 3);
      //      FITSDataSwapper<int_4> swout(&fiosc, 1);
      //      SwSegDataBlock<int_4> swsd(swout, SWSEGSZ, 3);
      double * fp = swsd.GetSegment(0);
      fp[0] = 6.54321;   fp[1] = 65.4321;  fp[2] = 654.321;  fp[3] = 6543.21;
      fp = swsd.GetSegment(1);
      fp[0] = 2.56789;   fp[1] = 25.6789;  fp[2] = 256.789;  fp[3] = 2567.89;
      fp = swsd.GetSegment(2);
      fp[0] = 12.567;   fp[1] = 225.67;  fp[2] = 3256.7;  fp[3] = 42567.;
      tags = swsd.GetSwapPosTagTable();
      cout << " Les pos-tags du FITS NbTag=" << tags.size() << endl;
      for (int kk=0; kk<tags.size(); kk++)  cout << tags[kk] << " ," ;
      cout << endl;
    }
    {
      cout << "6/ Creation PPFDataSwapper<float> avec lecture depuis swseg.ppf " << endl;
      FitsInOutFile si("swseg.fits", FitsInOutFile::Fits_RO);
      si.MoveAbsToHDU(2);
      FITSDataSwapper<double> swin(&si, 1);
      SwSegDataBlock<double> swsd(swin, tags, SWSEGSZ);
      cout <<"7/ Recopie ds SegDataBlock<float> depuis SwSegDataBlock<float> et print" << endl;
      SegDataBlock<double> segd;
      segd = swsd;
      segd.Print(cout, 4, "  ");
    }
    
  cout << "============ FIN  test_fdtable ======== ======= " << endl;  
}




