// This may look like C code, but it is really -*- C++ -*-
//                         C.Magneville          04/99
#ifndef TMATRIX_SEEN
#define TMATRIX_SEEN

#include "machdefs.h"
#include <stdio.h>
#include <iostream.h>
#include "ppersist.h"
#include "anydataobj.h"
#include "ndatablock.h"

namespace PlanckDPC {

template <class T>
class TMatrix : public AnyDataObj {
public:
  // Creation / destruction 
  TMatrix();
  TMatrix(uint_4 r,uint_4 c);
  TMatrix(uint_4 r,uint_4 c,T* values,Bridge* br=NULL);
  TMatrix(const TMatrix<T>& a);
  TMatrix(const TMatrix<T>& a,bool share);
  virtual ~TMatrix();

  // Temporaire?
  inline bool IsTemp(void) const {return mNDBlock.IsTemp();}
  inline void SetTemp(bool temp=false) const
                     {mNDBlock.SetTemp(temp);}

  // Gestion taille/Remplissage
  void Clone(const TMatrix<T>& a);
  void Reset(T v=0);
  void Realloc(uint_4 r,uint_4 c,bool force_alloc=true);

  // Informations pointeur/data
  inline int NRows() const {return mNr;}
  inline int NCol()  const {return mNc;}
  T const& operator()(uint_4 r,uint_4 c) const
                     {return *(mNDBlock.Begin()+r*mNc+c);}
  T&       operator()(uint_4 r,uint_4 c)
                     {return *(mNDBlock.Begin()+r*mNc+c);}
  inline       T* Data()       {return mNDBlock.Begin();}
  inline const T* Data() const {return mNDBlock.Begin();}
  inline       NDataBlock<T>& DataBlock()       {return mNDBlock;}
  inline const NDataBlock<T>& DataBlock() const {return mNDBlock;}

  // Operateur d'affectation
  TMatrix<T>& operator = (T x);
  TMatrix<T>& operator = (const TMatrix<T>& a);

  // Impression
  void Print(ostream& os,int lp=0,uint_4 i0=0,uint_4 ni=10,uint_4 j0=0,uint_4 nj=10) const;
  inline void Print(int lp=0,uint_4 i0=0,uint_4 ni=10,uint_4 j0=0,uint_4 nj=10) const
              {Print(cout,lp,i0,ni,j0,nj);}

  // Surcharge d'operateurs INPLACE
  TMatrix<T>& operator += (T b);
  TMatrix<T>& operator -= (T b);
  TMatrix<T>& operator *= (T b);
  TMatrix<T>& operator /= (T b);

  TMatrix<T>& operator += (const TMatrix<T>& a);
  TMatrix<T>& operator -= (const TMatrix<T>& a);
  TMatrix<T>& operator *= (const TMatrix<T>& a);

  // Pour surcharge d'operateurs
  TMatrix<T> Add(const TMatrix<T>& b) const;
  TMatrix<T> Sub(const TMatrix<T>& b) const;
  TMatrix<T> Mul(const TMatrix<T>& b) const;

protected:
  uint_4 mNr,mNc;
  NDataBlock<T> mNDBlock;
};

/////////////////////////////////////////////////////////////////////////
template<class T>
inline ostream& operator << (ostream& os, const TMatrix<T>& a)
                      {a.Print(os); return(os);}

/////////////////////////////////////////////////////////////////////////
template<class T>
inline TMatrix<T> operator + (const TMatrix<T>& a, double b) {
  TMatrix<T> result(a,false); result.DataBlock().SetTemp(true);
  result += b;
  return result;
}

template<class T>
inline TMatrix<T> operator + (double b,const TMatrix<T>& a) {
  TMatrix<T> result(a,false); result.DataBlock().SetTemp(true);
  result += b;
  return result;
}

template<class T>
inline TMatrix<T> operator - (const TMatrix<T>& a, double b) {
  TMatrix<T> result(a,false); result.DataBlock().SetTemp(true);
  result -= b;
  return result;
}

template<class T>
inline TMatrix<T> operator - (double b,const TMatrix<T>& a) {
  TMatrix<T> result(a,false); result.DataBlock().SetTemp(true);
  result.DataBlock() = b - result.DataBlock();
  return result;
}

template<class T>
inline TMatrix<T> operator * (const TMatrix<T>& a, double b) {
  TMatrix<T> result(a,false); result.DataBlock().SetTemp(true);
  result *= b;
  return result;
}

template<class T>
inline TMatrix<T> operator * (double b,const TMatrix<T>& a) {
  TMatrix<T> result(a,false); result.DataBlock().SetTemp(true);
  result *= b;
  return result;
}

template<class T>
inline TMatrix<T> operator / (const TMatrix<T>& a, double b) {
  TMatrix<T> result(a,false); result.DataBlock().SetTemp(true);
  result /= b;
  return result;
}

/////////////////////////////////////////////////////////////////////////
template<class T>
inline TMatrix<T> operator + (const TMatrix<T>& a,const TMatrix<T>& b)
                             {return a.Add(b);}

template<class T>
inline TMatrix<T> operator - (const TMatrix<T>& a,const TMatrix<T>& b)
                             {return a.Sub(b);}

template<class T>
inline TMatrix<T> operator * (const TMatrix<T>& a,const TMatrix<T>& b)
                             {return a.Mul(b);}

/////////////////////////////////////////////////////////////////////////
// Classe pour la gestion de persistance
template <class T>
class FIO_TMatrix : public  PPersist  {

public:
	    FIO_TMatrix();
	    FIO_TMatrix(string const & filename); 
	    FIO_TMatrix(const TMatrix<T> & obj);
	    FIO_TMatrix(TMatrix<T> * obj);
  virtual   ~FIO_TMatrix();

  virtual   AnyDataObj* DataObj();
  inline operator TMatrix<T>() { return(*dobj); }

protected :
  virtual void       ReadSelf(PInPersist&);           
  virtual void       WriteSelf(POutPersist&) const;  
  TMatrix<T> * dobj;
  bool ownobj;
};

} // Fin du namespace

#endif
