#include "machdefs.h"
#include "sopnamsp.h"

#include <stdio.h>
#include <string.h>
#include <iostream>
#include <typeinfo>

#include "datatable.h"
#include "fitsblkrw.h"
#include "fitshandler.h"

// #include "fitshdtable.h"

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
int FitsHandler<BaseDataTable>::CheckReadability(FitsInOutFile& is)
{
  if (is.CurrentHDUType() == IMAGE_HDU ) return 0;
  string key = "SOPCLSNM"; 
  if (is.KeyValue(key) == "SOPHYA::DataTable")  return 2;
  else return 1;
}

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
void FitsHandler<BaseDataTable>::Write(FitsInOutFile& os)
{
  
  if (dobj == NULL)   
    throw NullPtrError("FitsHandler<DataTable>::Write() NULL dobj pointer ");

  DataTable* dt = dynamic_cast< DataTable *> (dobj);
  if (dt == NULL) 
    throw FitsIOException("FitsHandler<DataTable>::Write() Not a DataTable object");
  
  int tbltyp = os.GetDef_TableType();
  string strcoltag;
  long strwidth = os.GetDef_StrColWidth(); 
  if (strwidth < 1) strwidth = 16;
  char buff[32];
  if (tbltyp == ASCII_TBL) 
    sprintf(buff, "A%ld",strwidth);
  else 
    sprintf(buff, "%ldA",strwidth);
  strcoltag = buff;

  vector<string> colnames, tform, tunit;
  for(sa_size_t k=0; k<dobj->NVar(); k++) { 
    bool fgoknm = true;
    bool fgoktun = true;
    switch ( dobj->GetColumType(k) ) {
    case BaseDataTable::IntegerField :
      if (tbltyp == ASCII_TBL) tform.push_back("I9");
      else tform.push_back("J");
      break;
    case BaseDataTable::LongField :
      if (tbltyp == ASCII_TBL) tform.push_back("I12");
      else tform.push_back("K");
      break;
    case BaseDataTable::FloatField :
      if (tbltyp == ASCII_TBL) tform.push_back("E12.5");
      else tform.push_back("E");
      break;
    case BaseDataTable::DoubleField :
    case BaseDataTable::DateTimeField :
      if (tbltyp == ASCII_TBL) tform.push_back("D15.8");
      else tform.push_back("D");
      if (dobj->GetColumType(k) == BaseDataTable::DateTimeField ) {
	tunit.push_back("Days (DateTimeField)");
	fgoktun = false;
      }
      break;
    case BaseDataTable::ComplexField :
      if (tbltyp == ASCII_TBL) { 
	cout << "FitsHandler<BaseDataTable>::Write()/Warning ComplexField not supported for ASCII_TBL " 
	     << endl;
	fgoknm = false;
      }
      else   tform.push_back("C");
      break;
    case BaseDataTable::DoubleComplexField :
      if (tbltyp == ASCII_TBL) {
	cout << "FitsHandler<BaseDataTable>::Write()/Warning DoubleComplexField not supported for ASCII_TBL " 
	     << endl;
	fgoknm = false;
      }
      else   tform.push_back("M");
      break;
    case BaseDataTable::StringField :
      tform.push_back(strcoltag);
      break;
    default:
      throw IOExc("FitsHandler<BaseDataTable>::Write() unknown column type ");
      break;
    }
    if (fgoknm) {
      colnames.push_back(dobj->GetColumName(k));
      if (fgoktun) tunit.push_back("");
    }
  }

  // On cree la table  
  string extname = os.NextExtensionName();
  os.CreateTable(os.GetDef_TableType(), extname, colnames, tform, tunit);

  // Ecriture des donnees des colonnes
  for(sa_size_t l=0; l<dobj->NEntry(); l+=dobj->SegmentSize()) { 
    sa_size_t icol = 0;
    sa_size_t sz = dobj->SegmentSize();
    sa_size_t iseg = l/sz;
    if ((l+sz) > dobj->NEntry()) sz = dobj->NEntry()-l;
    for(sa_size_t k=0; k<dobj->NVar(); k++) { 
      sa_size_t sk = dobj->mNames[k].ser;
      //DBG cout << "DBG-A k= " << k << " nom=" << dobj->mNames[k].nom << " ser=" << sk
      //DBG   << " type=" << dobj->GetColumType(k) << endl;
      switch ( dobj->GetColumType(k) ) {
      case BaseDataTable::IntegerField :
	icol++;
	FitsBlockRW<int_4>::WriteColumnData(os, icol, l+1, 1, 
					    dt->mICols[sk].GetCstSegment(iseg), sz);
	break;
      case BaseDataTable::LongField :
	icol++;
	FitsBlockRW<int_8>::WriteColumnData(os, icol, l+1, 1, 
					    dt->mLCols[sk].GetCstSegment(iseg), sz);
	break;
      case BaseDataTable::FloatField :
	icol++;
	FitsBlockRW<r_4>::WriteColumnData(os, icol, l+1, 1, 
					  dt->mFCols[sk].GetCstSegment(iseg), sz);
	break;
      case BaseDataTable::DoubleField :
      case BaseDataTable::DateTimeField :
	icol++;
	FitsBlockRW<r_8>::WriteColumnData(os, icol, l+1, 1, 
					  dt->mDCols[sk].GetCstSegment(iseg), sz);
	break;
      case BaseDataTable::ComplexField :
	if (tbltyp == BINARY_TBL) { 
	  icol++;
	  FitsBlockRW< complex<r_4> >::WriteColumnData(os, icol, l+1, 1, 
						       dt->mYCols[sk].GetCstSegment(iseg), sz);
	}
	break;
      case BaseDataTable::DoubleComplexField :
	if (tbltyp == BINARY_TBL) { 
	  icol++;
	  FitsBlockRW< complex<r_8> >::WriteColumnData(os, icol, l+1, 1, 
						       dt->mZCols[sk].GetCstSegment(iseg), sz);
	}
	break;
      case BaseDataTable::StringField :
	icol++;
	FitsBlockRW<std::string>::WriteColumnData(os, icol, l+1, 1, 
						  dt->mSCols[sk].GetCstSegment(iseg), sz);
	break;
      default:
	break;
      }
    }
  }
  // Ecriture de SegmentSize et autre elements de DVList
  
  os.WriteHeaderRecords(dobj->Info());
  MuTyV mtv = dobj->SegmentSize();
  os.WriteKey("SEGMSIZE",mtv," SOPHYA::DataTable SegmentSize");
  mtv = "SOPHYA::DataTable";
  os.WriteKey("SOPCLSNM",mtv," Object class name "); 
}



DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
void FitsHandler<BaseDataTable>::Read(FitsInOutFile& is)
{
 
  int hdutyp = is.CurrentHDUType();
  if ( (hdutyp != BINARY_TBL ) && (hdutyp != ASCII_TBL) )
    throw FitsIOException("FitsHandler<DataTable>::Read() Not a binary or ascii table HDU");

  sa_size_t segsz = is.GetNbRows() / 16; // Taille de segment par defaut 
  if (segsz > 2048) segsz = 2048;
  string key = "SEGMSIZE";
  bool knex = false;
  string ssegsz = is.KeyValue(key, knex);
  if (!knex && (ssegsz.length() > 0))  segsz = atoi(ssegsz.c_str());
  if (segsz < 16) segsz = 16;

  if (dobj == NULL) { // On cree la table si besoin 
    dobj = new DataTable(segsz);
  }
  else { 
    dobj->Clear();  // On efface la table sinon 
    dobj->mSegSz = segsz;
  }

  // On gere les DataTable pour le moment ... 
  DataTable* dt = dynamic_cast< DataTable *> (dobj);
  if (dt == NULL) 
    throw FitsIOException("FitsHandler<DataTable>::Read() Not a DataTable object");
  
  vector<string> colnames;
  vector<int> coltypes;
  vector<long> repcnt, width;
  vector<long> colpos;
  is.GetColInfo(colnames, coltypes, repcnt, width);
  // --ATTENTION-- repcnt (contenu=vecteur) pas pris en compte pour le moment 
  for(sa_size_t k=0; k<colnames.size(); k++) { 
    switch ( coltypes[k] ) {
    case TBYTE :
    case TSHORT :
    case TUSHORT :
    case TINT :
      dt->AddIntegerColumn(colnames[k]);
      colpos.push_back(k+1);
      break;
    case TUINT:
    case TLONG :
    case TULONG :
#ifdef TLONGLONG
    case TLONGLONG :
#endif      
      dt->AddLongColumn(colnames[k]);
      colpos.push_back(k+1);
      break;
    case TFLOAT :
      dt->AddFloatColumn(colnames[k]);
      colpos.push_back(k+1);
      break;
    case TDOUBLE :
      dt->AddDoubleColumn(colnames[k]);
      colpos.push_back(k+1);
      break;
    case TCOMPLEX :
      dt->AddComplexColumn(colnames[k]);
      colpos.push_back(k+1);
      break;
    case TDBLCOMPLEX :
      dt->AddDoubleComplexColumn(colnames[k]);
      colpos.push_back(k+1);
      break;
    case TSTRING :
      dt->AddStringColumn(colnames[k]);
      colpos.push_back(k+1);
      break;
    default:
      cout << "FitsHandler<BaseDataTable>::Read() NOT handled field type " 
	   << coltypes[k] << endl;
      break;
    }
  }

  // ------- Mise a jour des champs Nb d'entrees, nb segments ...
  dobj->mNEnt = is.GetNbRows();
  while ((dobj->SegmentSize()*dobj->NbSegments()) < dobj->NEntry())
    dobj->Extend();
  //DBG  cout << " DBG2 -- dobj->mNSeg = " << dobj->NbSegments() << " SegSize=" 
  //DBG   << dobj->SegmentSize() << " NEntry=" << dobj->NEntry() << endl;

  // Lecture des donnees des colonnes
  for(sa_size_t l=0; l<dobj->NEntry(); l+=dobj->SegmentSize()) { 
    sa_size_t icol = 0;
    sa_size_t sz = dobj->SegmentSize();
    sa_size_t iseg = l/sz;
    if ((l+sz) > dobj->NEntry()) sz = dobj->NEntry()-l;
    for(sa_size_t k=0; k<dobj->NVar(); k++) { 
      sa_size_t sk = dobj->mNames[k].ser;
      icol = colpos[k];
      //      cout << " DBG-3 , k=" << k << " icol=" << icol << endl;
      switch ( dobj->GetColumType(k) ) {
      case BaseDataTable::IntegerField :
	FitsBlockRW<int_4>::ReadColumnData(is, icol, l+1, 1, 
					    dt->mICols[sk].GetSegment(iseg), sz);
	break;
      case BaseDataTable::LongField :
	FitsBlockRW<int_8>::ReadColumnData(is, icol, l+1, 1, 
					   dt->mLCols[sk].GetSegment(iseg), sz);
	break;
      case BaseDataTable::FloatField :
	FitsBlockRW<r_4>::ReadColumnData(is, icol, l+1, 1, 
					 dt->mFCols[sk].GetSegment(iseg), sz);
	break;
      case BaseDataTable::DoubleField :
      case BaseDataTable::DateTimeField :
	FitsBlockRW<r_8>::ReadColumnData(is, icol, l+1, 1, 
					 dt->mDCols[sk].GetSegment(iseg), sz);
	break;
      case BaseDataTable::ComplexField :
	FitsBlockRW< complex<r_4> >::ReadColumnData(is, icol, l+1, 1, 
						    dt->mYCols[sk].GetSegment(iseg), sz);
	break;
      case BaseDataTable::DoubleComplexField :
	FitsBlockRW< complex<r_8> >::ReadColumnData(is, icol, l+1, 1, 
						    dt->mZCols[sk].GetSegment(iseg), sz);
	break;
      case BaseDataTable::StringField :
	FitsBlockRW<std::string>::ReadColumnData(is, icol, l+1, 1, 
						 dt->mSCols[sk].GetSegment(iseg), sz);
	break;
      default:
	break;
      }
    }
  }

  // Mise a jour nombre d'entree 
  // Lecture DVList   
  is.GetHeaderRecords(dobj->Info());
}




