// Classe d'initialisation du module FitsIOServer

#include "sopnamsp.h"
#include "machdefs.h"
#include "fiosinit.h"
#include "fitsmanager.h"
#include "fitshdtable.h"
#include "fitsarrhand.h"

#include <iostream> 

/*! 
  \class SOPHYA::FitsIOServerInitiator
  \ingroup FitsIOServer
  Perform registration of fits handlers.
  \sa SOPHYA::FitsManager
 */
int FitsIOServerInitiator::FgInit = 0;

FitsIOServerInitiator::FitsIOServerInitiator()
  : SophyaInitiator()
{
  FitsIOServerInitiator::FgInit++;
  if (FitsIOServerInitiator::FgInit > 1)  return;

//   Enregistrement des classes FitsHandler
//  FitsManager::RegisterHandler(new FitsArrayHandler<int_2> , "TArray<int_2>");
  cout << " ---- FitsIOServerInitiator / DEBUG ---- debut RegisterHandler " << endl;
  FitsManager::RegisterHandler(new FitsArrayHandler<int_4> , "TArray<int_4>");
  FitsManager::RegisterHandler(new FitsArrayHandler<r_4> , "TArray<r_4>");
  FitsManager::RegisterHandler(new FitsArrayHandler< r_8 > , "TArray<r_8>");

  FitsManager::RegisterHandler(new FitsHandler<BaseDataTable>, "DataTable");

  cout << " ---- FitsIOServerInitiator / DEBUG ---- ListHandlers() : " << endl;
  FitsManager::ListHandlers();
}

FitsIOServerInitiator::~FitsIOServerInitiator()
{
  FitsIOServerInitiator::FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques  
// static FitsIOServerInitiator s_fios_init_;

