# ----------------------------------------
# --------- File AIX_xlC_make.inc --------
#   Compilation avec xlC / AIX (IBM) 
# -------------     Dec 2005 -------------

#  Liste des librariries externes 
SOPEXTLIBS = $(SOPEXTLIBP) $(SOPEXTLIBLIST) 
#  Pour link fortran -lxlf -lxlfutil -lf 
SOPEXTLIBS = $(SOPEXTLIBP) $(SOPEXTLIBLIST) -lxlf -lxlfutil -lf

#  Chemin et librairie pour PI 
PIINC = 
PILIBS = -lXm -lXt -lX11 

#  Flag preprocesseur
CPPFLAGS = -DAIX -I$(SOPHYAINCP) $(PIINC)
#  Def compilateur C et flags
CC = xlc
CFLAGS = -O -g
#  Def compilateur C++ et flags
CXX =  xlC
#  Flag IBM xlC (Dec 2005) 
#  -qrtti=all : generate all RTTI infomation dynamic_cast + typeinfo
#  -qeh=v6 : Exception handling compatible with v6 
CXXFLAGS = -qrtti=all -qeh=v6 -O -g
# flags specifiques pour templates repository...
# CXXTEMPFLG = -qtemplateregistry=$(SOPHYAOBJP)/templateregistry -qtemplaterecompile
CXXTEMPFLG =
#  Compilo fortran
FC = xlf
FFLAGS =  
# Pour fabriquer les lib .a
AR = ar
ARFLAGS = -rcs


#  Ordres de compilation
CCOMPILE = $(CC) $(CPPFLAGS) $(CFLAGS) -c 
CXXCOMPILE = $(CXX) $(CPPFLAGS) $(CXXFLAGS) -c 
FCCOMPILE = $(FC) $(FFLAGS) -c 

#  Extension de nom pour les librairies partagees
SLEXT = so
#  Fabrication de librairies partagees 
CMDSHLCXX = $(CXX) $(CXXFLAGS) $(CXXTEMPFLG) -brtl -qmkshrobj 


#  Liste de librairie de base, necessaire pour libsophya
SOPBASELIBS = -lpthread -lm -lc -ldl 
LIBFORT = 

# --- Chemin pour l ensemble les librairies SOPHYA , +ExtLibs, +PI
SOPHYASLBLIST = -L$(SOPHYASLBP) -lsophya  $(SOPBASELIBS)
SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lextsophya -lsophya $(SOPEXTLIBS) $(SOPBASELIBS)
SOPHYAALLSLBLIST = -L$(SOPHYALIBP) -lPIext -lPIGcont -lPI -L$(SOPHYASLBP) -lextsophya -lsophya $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)

#  Commande de link pour creation d'executables
CXXLINK = $(CXX) $(CXXFLAGS) -brtl 
CLINK = $(CC) $(CFLAGS)
FCLINK = $(FC) $(FFLAGS)

#  Commande de link pour creation de module pouvant etre charge dynamiquement
CXXDLL = $(CXX) $(CXXFLAGS) -qmkshrobj 
