#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>

#include "sopnamsp.h"
#include "histinit.h"
#include "datatable.h"
#include "fitshdtable.h"
#include "swfitsdtable.h"

/* 
   Programme de test lecture-ecriture FITS de DataTable
    + test classe SwFitsDataTable
      Oct 2005 - Jan 2006
*/

void test_fdtable() ; 

int main(int narg, char *arg[])
{
  SophyaInit();
  try {
    test_fdtable();
  }
  catch(PThrowable exc ) {
    cerr << "tfitsdt-main() , Catched exception: \n" << exc.Msg() << endl;
  }
  catch(std::exception ex) {
    cerr << "tfitsdt-main() , Catched exception ! " << (string)(ex.what()) << endl;
  }
  catch(...) {
    cerr << "tfitsdt-main() , Catched ... ! " << endl;
  }
}


void test_fdtable() 
{
  int NL = 600;
  DataTable refdt(100); // Reference DataTable - for tests 

  cout << "======= test_fdtable: Simple DataTable+FITS test ======= " << endl;
  {
    cout << "1/ Creating DataTable / Writing to FITS " << endl;
    DataTable dt(64);
    dt.AddIntegerColumn("line");
    dt.AddDoubleColumn("x");
    dt.AddFloatColumn("f_sin");
    dt.AddDoubleColumn("f_x2");
    dt.AddStringColumn("str_line");
    dt.AddComplexColumn("cmplx_cos_sin");
    MuTyV rec[10];
    char sbuff[32];
    cout << " Filling ... (NLines=" << NL << ")" << endl;
    for(int k = 0; k<NL; k++) {
      rec[0] = k;
      double x = M_PI*k/100.;
      double fx = sin(x)*cos(x);
      rec[1] = x+1;
      rec[2] = sin(x);
      rec[3] = x*x;
      sprintf(sbuff, "SL-%d", k);
      rec[4] = sbuff;
      double sx = sin(x);
      double cx = cos(x);
      rec[5] = complex<r_4>(cx, sx);
      dt.AddLine(rec);
    }
    cout << dt;
    cout << " Copying dt to refdt (refdt = dt) " << endl;
    refdt = dt;
    cout << " Writing dt to fits file dtable.fits ... " << endl;
    FitsInOutFile fios("!dtable.fits", FitsInOutFile::Fits_Create);
    fios << dt;
    cout << " Writing dt to fits as ASCII table with extname= ASC_DTable ... " << endl;
    fios.SetDef_AscTable();
    fios.SetNextExtensionName("ASC_DTable");
    fios << dt;    
    cout << "1.b/ Creating SwFitsDataTable (file swdtable.fits) " << endl;
    FitsInOutFile swf("!swdtable.fits", FitsInOutFile::Fits_Create);
    SwFitsDataTable swdt(swf, 64);
    cout << " Copying from DataTable dt ..." << endl;
    swdt = dt;
    cout << swdt;
  }
  {
    cout << "2/ Reading DataTable from FITS " << endl;
    FitsInOutFile fios("dtable.fits", FitsInOutFile::Fits_RO);
    cout << fios ;
    fios.MoveToNextHDU();
    DataTable dtr;
    fios >> dtr;
    cout << dtr;
    cout << "2.b/  dtr.LineHeaderToString() dtr.LineToString(k)   : " << endl;
    cout << dtr.LineHeaderToString() << endl;
    for(int k = 0; k<NL; k+=NL/12) 
      cout << "Line[" << k << "] " << dtr.LineToString(k) << endl ;  
    cout << "2.b/  Reading from ASCII table   " << endl;
    DataTable dtra;
    fios >> dtra;
    cout << dtra;
    cout << dtra.LineHeaderToString() << endl;
    for(int k = 0; k<NL; k+=NL/12) 
      cout << "Line[" << k << "] " << dtra.LineToString(k) << endl ;  

    cout << "2.c/  Reading SwFitsDataTable from  swdtable.fits  " << endl;   
    SwFitsDataTable swdtr;
    FitsInOutFile swf("swdtable.fits", FitsInOutFile::Fits_RO);   
    swf.MoveAbsToHDU(2);  
    swf >> swdtr;
    cout << swdtr;
    cout << swdtr.LineHeaderToString() << endl;
    for(int k = 0; k<NL; k+=NL/12) 
      cout << "Line[" << k << "] " << swdtr.LineToString(k) << endl ;  
  }
  cout << "============ FIN  test_fdtable =============== " << endl;  
}




