#include "machdefs.h"
#include "sopnamsp.h"

#include <stdio.h>
#include <string.h>
#include <iostream>
#include <typeinfo>

#include "fitsmanager.h"
#include "fitshandler.h"

struct hand_list_el {
  FitsHandlerInterface * fhi;
  int glev;
  string desc;
};

typedef list<hand_list_el> HandlerList;

static HandlerList * hlistp = NULL;

static inline void ChkHLP() 
{
  if (hlistp == NULL) hlistp = new HandlerList;
}
/*!
  \param fhi : handler object pointer (created by new) which will be kept in the 
  handler list
  \param glev : global priority level associated with the handler. Used when different
  handlers return the same value for CheckHandling() or CheckReadability().
  \param desc : classe name description associated with the handler
*/
int FitsManager::RegisterHandler(FitsHandlerInterface * fhi, int glev, string desc)
{
  ChkHLP(); 
  if (fhi == NULL)
    throw NullPtrError("FitsManager::RegisterHandler() fhi=NULL ");
  HandlerList::iterator it;
  for(it = hlistp->begin(); it != hlistp->end(); it++) {
    if (typeid(*((*it).fhi)) == typeid(*fhi)) 
      throw DuplicateIdExc("FitsManager::RegisterHandler() Already registered handler");
  }
  hand_list_el hle;
  hle.fhi = fhi;
  hle.glev = glev;
  hle.desc = desc;
  hlistp->push_back(hle);
  return hlistp->size();
}

int FitsManager::ListHandlers()
{
  ChkHLP(); 
  int kk=0;
  cout << "---- FitsManager::ListHandlers()  NbHandlers= " << hlistp->size()
       << endl;
  HandlerList::iterator it;
  for(it = hlistp->begin(); it != hlistp->end(); it++) {
    kk++;
    cout << kk << "- " << (*it).desc << " : " 
	 << typeid(*((*it).fhi)).name() << " glev= " <<(*it).glev << endl;
  }
  return hlistp->size();
}

FitsHandlerInterface* FitsManager::FindHandler(AnyDataObj & o)
{
  ChkHLP(); 
  FitsHandlerInterface * fhi = NULL;
  HandlerList::iterator it;
  int hfg = 0;
  int bhfg = 0;
  int clev = 0;
  int blev = 0;
  for(it = hlistp->begin(); it != hlistp->end(); it++) {
    hfg = (*it).fhi->CheckHandling(o);
    if ( ( hfg > bhfg ) || ( (hfg == bhfg) && ((*it).glev > blev) ) ) {
      fhi = (*it).fhi;  bhfg = hfg;  blev = (*it).glev;
    }
  }
  if (fhi == NULL) {
    string msg = "FitsManager::FindHandler() Handler not found for ";
    msg += typeid(o).name();
    throw NotFoundExc(msg);
  }
  else return fhi;
}

void FitsManager::Write(FitsInOutFile& os, AnyDataObj & o)
{
  FitsHandlerInterface * fhi2 = FindHandler(o)->Clone();
  fhi2->SetDataObj(o);
  fhi2->Write(os);
  return;
}

void FitsManager::Read(FitsInOutFile& is, AnyDataObj & o)
{
  FitsHandlerInterface * fhi2 = FindHandler(o)->Clone();
  fhi2->SetDataObj(o);
  fhi2->Read(is);
  delete fhi2;
  return;
}

FitsHandlerInterface * FitsManager::FindReader(FitsInOutFile& is)
{
  ChkHLP(); 
  FitsHandlerInterface * fhi = NULL;
  HandlerList::iterator it;
  int hfg = 0;
  int bhfg = 0;
  int blev = 0;
  for(it = hlistp->begin(); it != hlistp->end(); it++) {
    hfg = (*it).fhi->CheckReadability(is);
    if ( ( hfg > bhfg ) || ( (hfg == bhfg) && ((*it).glev > blev) ) ) {
      fhi = (*it).fhi;  bhfg = hfg;  blev = (*it).glev;
    }
  }
  if (fhi == NULL) {
    string msg = "FitsManager::FindReader() Reader/Handler not found  ";
    msg += is.FileName();
    char buff[64];
    sprintf(buff, " HDU= %d Type= %d", (int)(is.CurrentHDU()), 
	    (int)(is.CurrentHDUType()) );
    msg += buff;
    throw NotFoundExc(msg);
  }
  else return fhi;
}

FitsHandlerInterface * FitsManager::Read(FitsInOutFile& is)
{
  FitsHandlerInterface * fhi2 = FindReader(is)->Clone();
  fhi2->Read(is);
  return fhi2;
}
