/* Interface Fits BINARY/ASCII Table     cmv 21/05/2001 */
/*    Ajout commandes generique lecture/ecriture FITS   */
/*                           Reza , Jan 2006            */


#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <stdio.h>
#include <typeinfo>
#include <iostream>
#include <string.h>
#include <string>

#include "nobjmgr.h"
#include "servnobjm.h"
#include "nomgadapter.h"
#include "pistdimgapp.h"
#include "fbtntintf.h"

#include "fitsmanager.h"
#include "fitshandler.h"
#include "fiosinit.h"

////////////////////////////////////////////////////////////
class NOMAdapter_FitsBT : public NObjMgrAdapter {
public:
  NOMAdapter_FitsBT(FitsBTNtuIntf* o = NULL);
  virtual ~NOMAdapter_FitsBT();

  virtual NObjMgrAdapter* Clone(AnyDataObj* o);
  virtual string GetDataObjType();
  virtual AnyDataObj* CloneDataObj(bool share=false);
  virtual void SavePPF(POutPersist& s, string const & nom);
  virtual void Print(ostream& os);
  virtual NTupleInterface* GetNTupleInterface(bool& adel);

protected:
  FitsBTNtuIntf* mFBT;
};

////////////////////////////////////////////////////////////
NOMAdapter_FitsBT::NOMAdapter_FitsBT(FitsBTNtuIntf* o)
 : NObjMgrAdapter(o)
{
mFBT = o;
}

NOMAdapter_FitsBT::~NOMAdapter_FitsBT()
{
}

NObjMgrAdapter* NOMAdapter_FitsBT::Clone(AnyDataObj* o)
{
FitsBTNtuIntf* g = dynamic_cast<FitsBTNtuIntf *>(o);
if(g) return ( new NOMAdapter_FitsBT(g) );
return ( new NObjMgrAdapter(o) );
}

string NOMAdapter_FitsBT::GetDataObjType()
{
return( "FitsBTNtuIntf " );
}

AnyDataObj* NOMAdapter_FitsBT::CloneDataObj(bool /*share*/)
{
return( new FitsBTNtuIntf(*mFBT) );
}

void NOMAdapter_FitsBT::SavePPF(POutPersist& pos, string const & nom)
{
cout<<"NOMAdapter_FitsBT::SavePPF: not implemented"<<endl;
}

void NOMAdapter_FitsBT::Print(ostream& os)
{
mFBT->Print(os,99);
}

NTupleInterface* NOMAdapter_FitsBT::GetNTupleInterface(bool& adel)
{
adel = false;
return(mFBT);
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
extern "C" {
void fitsbtadapter_init();
void fitsbtadapter_end();
}

class fitsbtadapterExecutor : public CmdExecutor {
public:
  fitsbtadapterExecutor();
  virtual ~fitsbtadapterExecutor();
  virtual int Execute(string& keyw, vector<string>& args, string& toks);
};

///////////////////////////////////////////////////////////
fitsbtadapterExecutor::fitsbtadapterExecutor()
{
FitsIOServerInit();  // On s'assure de l'initialisation du module FitsIOServer

NamedObjMgr omg;
PIACmd * mpiac = omg.GetImgApp()->CmdInterpreter();

// On enregistre l'adaptateur
Services2NObjMgr* serv = omg.GetServiceObj();
serv->RegisterClass(new FitsBTNtuIntf, new NOMAdapter_FitsBT);

// On enregistre la commande 
string hgrp = "FileIO";
string kw = "fitsadapt";
string usage = "fitsadapt: NTuple adaptor for Binary and ASCII Fits table\n" ;
usage += "Usage: fitsadapt fitsfile [nomobj hdu buflen[,bufsens,lp]]";
usage += "\n fitsfile : Fits file name";
usage += "\n nomobj : Object name (needed if file name misleading as C++ variable)";
usage += "\n hdu : Fits HDU (if <=0 take first binary/ascii table)";
usage += "\n buflen[,bufsens,lp] : buffer length (sens) for fits reading (default is 100,1,0)";
usage += "\n See also  scanfits writefits readfits ";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "scanfits";
usage = "scanfits: scan fits files and print information on each HDU\n" ;
usage += "Usage: scanfits FileName [slev=0 ... 3]\n";
usage += "slev=1,3: header keywords , slev=2,3: try to read each HDU";
mpiac->RegisterCommand(kw, usage, this, hgrp); 

kw = "writefits";
usage = "writefits: Write objects to a fits file \n" ;
usage += "Usage: writefits nameobj/pattern FileName \n";
usage += "(use FitsManager) .... ";
usage += "See also  scanfits readfits fitsadapt ";
mpiac->RegisterCommand(kw, usage, this, hgrp); 

kw = "readfits";
usage = "readfits: Read all HDU's of a fits file \n" ;
usage += "Usage: readfits nameobj/pattern FileName \n";
usage += "(use FitsManager) .... ";
usage += "See also  scanfits writefits fitsadapt ";
mpiac->RegisterCommand(kw, usage, this, hgrp); 
}

fitsbtadapterExecutor::~fitsbtadapterExecutor()
{
}

int fitsbtadapterExecutor::Execute(string& kw, vector<string>& tokens, string&)
{
NamedObjMgr omg;
if(kw == "fitsadapt") {
  if(tokens.size()<1)
    {cout<<"Usage: fitsadapt fitsfile [nomobj hdu buflen[,bufsens]]"<<endl;
     return(0);}
    int ihdu=0;
    int_4 buflen=100, bufsens=1, lp=0;
    string fname = tokens[0];
    string nom_obj ="";
    if(tokens.size()>1) nom_obj = tokens[1];
    if(tokens.size()>2) sscanf(tokens[2].c_str(),"%d",&ihdu);
    if(tokens.size()>3) sscanf(tokens[3].c_str(),"%d,%d,%d",&buflen,&bufsens,&lp);
    FitsBTNtuIntf* fbt = new FitsBTNtuIntf(fname,ihdu,buflen,bufsens,lp);

    if(nom_obj=="" || nom_obj=="!") nom_obj = omg.GetServiceObj()->FileName2Name(fname);
    omg.AddObj(fbt,nom_obj);
 }
else if (kw == "scanfits") {
  if(tokens.size() < 1)  {
    cout<<"Usage: scanfits FileName [slev] "<<endl;
    return 1;
  }
  int slev = 0;
  if(tokens.size() > 1)  slev = atoi(tokens[1].c_str());
  FitsManager::ScanFile(tokens[0], slev); 
  return 0;
}
else if (kw == "writefits") {
  if(tokens.size() < 2)  {
    cout<<"Usage: writefits nameobj/pattern FileName "<<endl;
    return 1;
  }
  vector<string> noms;
  omg.GetObjList(tokens[0], noms);
  if (noms.size() < 1) {
    cout<<"writefits/Error: no object with this name "<<endl;
    return 2;
  }
  cout << "writefits: Opening/Creating fits file " << tokens[1] << endl;
  FitsInOutFile fos(tokens[1], FitsInOutFile::Fits_Create);
  for(int kk=0; kk<noms.size(); kk++) {
    AnyDataObj* co = omg.GetObj(noms[kk]);
    if (co == NULL) continue;
    fos.SetNextExtensionName(noms[kk]);
    try {
      FitsManager::Write(fos, *co);
      cout << "writefits: Object " << noms[kk] << " written to HDU No " << fos.CurrentHDU() << endl;  
    }
    catch (NotFoundExc & exc) {
      cout << "writefits/Error writing object " << noms[kk] << " -> " << exc.Msg() << endl;
    }
  }
  return 0;
}
else if (kw == "readfits") {
  if(tokens.size() < 1)  {
    cout<<"Usage: readfits FileName "<<endl;
    return 1;
  }
  cout << "readfits: Opening  fits file " << tokens[0] << endl;
  FitsInOutFile fis(tokens[0], FitsInOutFile::Fits_RO);
  string bnom = omg.GetServiceObj()->FileName2Name(tokens[0]);
  string nom = bnom;
  char bun[16];
  int kon = 0;
  for(int k=0; k<fis.NbHDUs(); k++) {
    try {
      FitsHandlerInterface* fhi = FitsManager::Read(fis);
      AnyDataObj* obj = fhi->DataObj();
      if (obj) {
       kon++;
       if (kon > 1)  { 
	 sprintf(bun, "%d", kon);
	 nom = bnom + bun;
       }
       omg.AddObj(obj, nom, false);
       cout << "readfits: " << (string)typeid(*obj).name()
	    << "  read From HDU " << k+1 << " ->" << nom << endl;
      }
      else delete fhi; 
      //Reza, Jan 2006: Sinon, le fhi ne sera jamais supprime, tant pis 
      // Il ne prend pas beaucoup de place, une fois que son objet est delete
    }
    catch (NotFoundExc & exc) {
      cout << "readfits/Error - HDU=" << k+1 << " : " << exc.Msg() << endl;
    }
    fis.MoveToNextHDU();
  }
  return 0;  
}
 return(0);
}

///////////////////////////////////////////////////////////
static fitsbtadapterExecutor * piafbtex = NULL;

void fitsbtadapter_init()
{
if(piafbtex) delete piafbtex;
piafbtex = new fitsbtadapterExecutor;
}

void fitsbtadapter_end()
{
if(piafbtex) delete piafbtex;
piafbtex = NULL;
}
