//  Classe de base pour les fentre de premier niveau
//  dans les programmes graphiques interactives
//
//                  E.Aubourg , R. Ansari  96 - 98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "piwindowgen.h"
#include "psfile.h"

//++
// Class	PIWindow
// Lib		PI
// include	piwindowgen.h
//
//	Classe de conteneur (drivant de *PIContainer") spcialise pour 
//	la cration des fentres de premier niveau, gre par l'application
//	"WindowManager". La classe "PIWindow" a  implementation dpendante 
//	du systeme utilis (Mac, XWindow, ...). La classe "PIWindowGen" est 
//	la classe qui dfinit l'interface, et ne pas doit tre instancie 
//	directement (Mthodes virtuelles pures). Les objets instancis sont 
//	de la classes "PIWindow" et le fichier entte correspondant est 
//	"PIWIN_H" dfini dans "pisysdep.h"
//--
//++
// Links	Parents
// PIContainer
//--
//++
// Titre	Constructeur
//--
//++
// PIWindowGen(PIMsgHandler* par, char *nom, PIWindowKind k=PIWK_normal, int sx=10, int sy=10, int px=0, int py=0)
//	Cration d'une fentre de haut niveau. La variable "PIWindowKind k"  contrle
//	le comportement de l'objet vis  vis de l'application WindowManager. Le comportement
//	exacte, ainsi que l'apparence graphique dpend de la plateforme et du WindowManager
//	utiliss. "par" est le l'objet "PIMsgHandler" dont dpend la fentre, en gnral un objet
//	de la classe "PIApplication". "nom" dsigne le nom, "sx,sy" la taille et 
//	"px,py" la position de l'objet.
//	- "PIWK_normal" : fentre ordinaire
//	- "PIWK_floating" : fentre qui reste en avant plan 
//	- "PIWK_dialog" : fentre de dialogue 
//	- "PIWK_transient" : fentre apparaissant an avant plan, sans barre de contrle 
// long kind()
//	Renvoie le type de la classe de l'objet ("=PIWindowGen::ClassId") pour cette classe.
//--

//++
// Titre	Mthodes
//--
//++
// void  AutoHideOnClose(bool ahc=true)
//	Contrle le comportement par dfaut de l'objet quand la fentre est ferme
//	 travers le WindowManager. si "ahc=true", "Hide()" est appel. 
//	Le message de l'objet avec le qualificatif "PIMsg_Clos est transmis
//	au "PIMsgHandler" parent.
// void  PSPrint(PSFile *psf, int ofx=0, int ofy=0)
//	Dfinit une nouvelle page et appelle la mthode "PSPrint()" pour tous les
//	objets "PIWdg" contenus dans la fentre.
//--


/* --Methode-- */
PIWindowGen::PIWindowGen(PIMsgHandler *par, char *nom, PIWindowKind k, 
                         int sx, int sy, int px, int py)
: PIContainer(NULL, nom, sx, sy, px, py), mWtyp(k)
{
  SetMsgParent(par);
  AutoHideOnClose();
}


/* --Methode-- */
PIWindowGen::~PIWindowGen()
{}

/* --Methode-- */
void PIWindowGen::PSPrint(PSFile *psf, int ofx, int ofy)
{
if (!psf) return;
//int ori;
//ori = (XSize() > YSize()) ? LANDSCAPE : PORTRAIT ;
psf->NewPage((float)XSize(), (float)YSize(),PI_Auto);
PIContainerGen::PSPrint(psf, ofx, ofy);
}


/* --Methode-- */
void PIWindowGen::Process(PIMessage msg, PIMsgHandler* sender, void* data)
/*  On intercepte le message Active, et Close avant de les renvoyer */
/*  avec un message ActiveWdg de la part de la fenetre              */
{
if (ModMsg(msg) == PIMsg_ResizeRequest) { 
  // On change la taille de la fenetre - data est un pointeur sur entier
  // data[0] represente l'increment (positif ou negatif) en X, data[1] en Y
  int* nsz = (int*) data;
  SetSize(XSize()+nsz[0], YSize()+nsz[1]);
  return;
  }
else if ((msg == BuildMsg(Msg(), PIMsg_Close)) && (sender == this) && mAHC) {
  Hide();   // Action par defaut en cas de MsgClose.
  ReSend(msg, sender, data);
  }
else if (ModMsg(msg) == PIMsg_Active) {
  ReSend(msg, sender, data);
  PIWdg * sndw = dynamic_cast<PIWdg *>(sender);
  if (sndw && (sndw->kind() != PIWindowGen::ClassId))  Send(Msg(),PIMsg_Active);
  }
else ReSend(msg, sender, data);
return;  
}
