// This may look like C code, but it is really -*- C++ -*-
// Classe de gestion d objets nommes pour piapp
// Reza      Aout 97 , Juillet,Aout 98
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef NOBJMGR_H_SEEN
#define NOBJMGR_H_SEEN

#include "ppersist.h"
#include "dlftypes.h"

class PIStdImgApp;
class Services2NObjMgr;

class NamedObjMgr {
public:
			NamedObjMgr();
  virtual		~NamedObjMgr();

  virtual void 		SetImgApp(PIStdImgApp* app);


//  Pour ajouter, supprimer et acceder aux objets PPersist
  virtual void		AddObj(PPersist* obj, string& nom);
  virtual void          DelObj(string const& nom, bool fgd=true);
  virtual void		DelObjects(string const& patt, bool fgd=true); 
  virtual PPersist*	GetObj(string const& nom);
  virtual void		RenameObj(string const& nom, string& nomnew);
  virtual string        LastObjName();  // Renvoie le nom du dernier objet ajoute

//  Lecture et sauvegarde des objets sur fichier
  virtual void		ReadObj(PInPersist& s, int num=-1);
  virtual void		ReadObj(string const & nomppf, string nobj="");
  virtual void		ReadAll(string const & nomppf);
  virtual void		ReadFits(string const & flnm, string nobj="");
  virtual void          SaveObj(string const& nom, POutPersist& s);
  virtual void          SaveAll(string const& nomppf);
  virtual void          SaveFits(string const& nom, string const & flnm);

// Info sur les objets 
  virtual void          ListObjs();  		
  virtual void          PrintObj(string const& nom);

//  Affichage des objets 
  virtual void          DisplayObj(string const& nom, string dopt="");
  virtual void          DisplaySurf3D(string const& nom, string dopt="");
  virtual void          DisplayNT(string const& nom, string& nmx, string& nmy, string& nmz,  
                                  string& erx, string& ery, string& erz, string dopt="");
  virtual void          DisplayGFD(string const& nom, string& numvarx, string& numvary, string& err, string dopt="");
// virtual void          DisplayImage(string const& nom, string dopt=""); C'est necessaire ??

  virtual void		SetGraphicAttributes(string gratt="");
  virtual void		SetGraphicWinZone(int nzx, int nzy, bool fcr=false);


//  Trace d'expression de NTuple, et d'autres objets
  virtual void          DisplayPoints2D(string const& nom, string& expx, string& expy,
                                        string& experrx, string& experry, 
                                        string& expcut, string dopt="");
  virtual void          DisplayPoints3D(string const& nom, string& expx, string& expy, string& expz, 
                                        string& expcut, string dopt="");
//  Projection d'expressions dans histogramme (et trace) 
  virtual void          ProjectH1(string const& nom, string& expx, string& expwt, string& expcut, 
                                  string& nomh1, string dopt="");
  virtual void          ProjectH2(string const& nom, string& expx, string& expy, string& expwt, 
                                  string& expcut, string& nomh2, string dopt="");
  virtual void          ProjectHProf(string const& nom, string& expx, string& expy, string& expwt, 
                                  string& expcut, string& nomprof, string dopt="");
//  Projection d'expression dans vecteurs et dans n-tuple
  virtual void          FillVect(string const& nom, string& expx, string& expcut, 
                                 string& nomvec, string dopt="");
  virtual void          FillNT(string const& nom, string& expx, string& expy, string& expz,
                               string& expt, string& expcut, string& nomnt); 
  virtual void          FillGFD(string const& nom, string& expx, string& expy, string& expz,
                               string& experr, string& expcut, string& nomgfd);

// Trace de fonctions 1-D , 2-D
  virtual void          PlotFunc(string& expfunc, float xmin, float xmax, int np=100, string dopt="");
  virtual void          PlotFunc2D(string& expfunc, float xmin, float xmax, float ymin, float ymax, 
                                   int npx=50, int npy=50, string dopt="");
  virtual void          PlotFunc(DlFunctionOfX f, float xmin, float xmax, int np=100, string dopt="");
  virtual void          PlotFunc2D(DlFunctionOfXY f, float xmin, float xmax, float ymin, float ymax, 
                                   int npx=50, int npy=50, string dopt="");

//   Methodes de fit, a rajouter  (pour CMV , deux methodes H1 H2 ou 1 seule ??) ...
  virtual void          Fit12D(string const& nom, string& func,
                              string par,string step,string min,string max,string opt);


// Acces au PIApplication et a la classe de service 
  virtual PIStdImgApp*		GetImgApp();
  virtual Services2NObjMgr* 	GetServiceObj();
};


#endif
