#include "piacmd.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "basexecut.h"

#include "pdlmgr.h"
#include "ctimer.h"
// #include "dlftypes.h"

#include "pistdimgapp.h"
#include "nobjmgr.h"

#include PISTDWDG_H 
#include PILIST_H 

// ------------------------------------------------------------
//         Gestion d'une fenetre d'aide interactive        
// ------------------------------------------------------------

class PIAHelpWind : public PIWindow {
public :
		PIAHelpWind(PIStdImgApp* par, PIACmd* piacmd);
  virtual	~PIAHelpWind();
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
  inline  void	AddHelpItem(const char * hitem) 
			{ mNitem++;  hitemlist->AppendItem(hitem, 1000+mNitem); }
protected :
  PIStdImgApp* dap;
  PIACmd* piac;
  int mNitem;
  PIList* hitemlist;
  PIButton * mBut;
  PILabel * mLab;
  PIText* mTxt;
};

/* --Methode-- */
PIAHelpWind::PIAHelpWind(PIStdImgApp *par, PIACmd* piacmd)
  : PIWindow((PIMsgHandler *)par, "Help-PIApp", PIWK_normal,  400, 300, 100, 350)
{
dap = par;
piac = piacmd;
mNitem = 0;
SetMsg(777);

int bsx, bsy;
int tsx, tsy;
int spx, spy;
PIApplicationPrefCompSize(bsx, bsy);
spx = bsx/6;   spy = bsy/6;
tsx = 10*bsx+2*spx;  tsy = 7*bsy+3*spy;
SetSize(tsx,tsy);
hitemlist = new PIList(this, "hitemlist", bsx*2.0, tsy-2*spy, spx/2, spy);
hitemlist->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
// hitemlist->SetBorderWidth(2);
mTxt = new PIText(this, "helptext", bsx*8.0, 6*bsy, bsx*2.0+1.5*spx, spy);
mTxt->SetMutiLineMode(true);
mTxt->SetTextEditable(false);
mTxt->SetText("");
mTxt->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mLab = new PILabel(this, "helpitem", bsx*4, bsy, bsx*2.5+2*spx, tsy-spy-bsy);
mLab->SetBorderWidth(1);
mLab->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mLab->SetLabel("");
mBut = new PIButton(this, "Close", 700, bsx, bsy, tsx-bsx*1.5-spx, tsy-spy-bsy);
mBut->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
}

/* --Methode-- */
PIAHelpWind::~PIAHelpWind()
{
delete hitemlist;
delete mTxt;
delete mLab;
delete mBut;
}

/* --Methode-- */
void PIAHelpWind::Process(PIMessage msg, PIMsgHandler* sender, void* /*data*/)
{
PIMessage um = UserMsg(msg);
if (((um == 777) && (ModMsg(msg) == PIMsg_Close)) || (um == 700) ) {
  Hide();
  return;
  }
else if ( (um > 1000) && (sender == hitemlist)) {
  string s = hitemlist->GetSelectionStr();
  mTxt->SetText(piac->GetUsage(s));
  mLab->SetLabel(s);
  }  
}


static PIACmd* curpiacmd = NULL;
/* --Methode-- */
PIACmd::PIACmd(NamedObjMgr* omg, PIStdImgApp* app)
{
mObjMgr = omg; 
mImgApp = app;
system("cp history.pic hisold.pic");
hist.open("history.pic");
trace = false;   timing = false;
gltimer = NULL;

helpwin = new PIAHelpWind(app, this);

string kw = "piacmd";
string usage;
usage = ">>> (piacmd) Interpreter's keywords : \n";
usage += "  timingon  timingoff traceon  traceoff \n";
usage += "  set unset listvar listcommands exec shell \n";
usage += "  > set varname 'string'   # To set a variable, $varname \n";
usage += "  > unset varname          # clear variable definition \n";
usage += "  > listvars   # List of variable names and values \n";
usage += "  > listcommands # List of all known commands \n";
usage += "  > exec filename  # Execute commands from file \n";
usage += "  > shell comand_string  # Execute shell command \n";
usage += "  > help <command_name>  # <command_name> usage info \n"; 
usage += "  > helpwindow           # Displays help window \n";
RegisterCommand(kw, usage, NULL);

basexec = new PIABaseExecutor(this, omg, app);
AddInterpreter(this);
curcmdi = this;
}

/* --Methode-- */
PIACmd::~PIACmd()
{
hist.close();
if (gltimer) { delete gltimer;  gltimer = NULL; }
Modmap::iterator it;
for(it = modmap.begin(); it != modmap.end(); it++) {
  string name = (*it).first + "_end";
  DlModuleInitEndFunction fend = (*it).second->GetFunction(name);
  if (fend) fend();
  delete (*it).second;
  }
delete helpwin;
if (curpiacmd == this)  curpiacmd = NULL;
}

/* --Methode-- */
PIACmd* PIACmd::GetInterpreter()
{
return(curpiacmd);
}

/* --Methode-- */
string PIACmd::Name()
{
return("piacmd");
}

/* --Methode-- */
void PIACmd::RegisterCommand(string& keyw, string& usage, CmdExecutor * ce)
{
  // if (!ce) return;
cmdex cme;
cme.us = usage;
cme.cex = ce;
cmdexmap[keyw] = cme;
if (helpwin) helpwin->AddHelpItem(keyw.c_str());
}

/* --Methode-- */
void PIACmd::LoadModule(string& fnameso, string& name)
{
PDynLinkMgr * dynlink = new PDynLinkMgr(fnameso, false);
if (dynlink == NULL) {
  cerr << "PIACmd/LoadModule_Error: Pb opening SO " << fnameso << endl;
  return;
  }
string fname = name + "_init";
DlModuleInitEndFunction finit = dynlink->GetFunction(fname);
if (!finit) {
  cerr << "PIACmd/LoadModule_Error: Pb linking " << fname << endl;
  return;
  }
cout << "PIACmd/LoadModule_Info: Initialisation module" << name 
     << "  " << fname << "() ..." << endl;
finit();
modmap[name] = dynlink;
return;
}

/* --Methode-- */
void PIACmd::AddInterpreter(CmdInterpreter * cl)
{
if (!cl) return;
interpmap[cl->Name()] = cl;
}

/* --Methode-- */
void PIACmd::SelInterpreter(string& name)
{
InterpMap::iterator it = interpmap.find(name);
if (it == interpmap.end())   return;
curcmdi = (*it).second;
}


//  Pour le decoupage des commandes en lignes 
typedef vector<string> cmdtok;

/* --Methode-- */
int PIACmd::Interpret(string& s)
{

cmdtok tokens;
if (s.length() < 1)  return(0);

hist << s << endl;   // On enregistre les commandes 

if (s[0] == '#') {
  cout << "PIACmd::Interpret() Comment-Line:" << s << endl;
  return(0); 
  } 
string toks,kw;
size_t p = s.find_first_not_of(" ");
s = s.substr(p);
p = 0;
size_t q = s.find_first_of(" ");
size_t l = s.length();

if (q < l)
  {  kw = s.substr(p,q-p);  toks = s.substr(q, l-q); }
else { kw = s.substr(p,l-p);  toks = ""; }

q = 0;
while (q < l)  {
  p = toks.find_first_not_of(" ",q+1); // au debut d'un token
  if (p>=l) break;
  q = toks.find_first_of(" ",p); // la fin du token;
  string token = toks.substr(p,q-p);
  tokens.push_back(token);
  }

for(int k=0; k<tokens.size(); k++) { // On remplace les $varname par la valeur de la variable
  if ((tokens[k])[0] != '$')  continue; 
  CmdVarList::iterator it = mVars.find(tokens[k].substr(1));
  if (it != mVars.end())  tokens[k] = (*it).second;
  }

// cout << "PIACmd::Do() DBG  KeyW= " << kw << " NbArgs= " << tokens.size() << endl;
//  for(int ii=0; ii<tokens.size(); ii++)
//  cout << "arg[ " << ii << " ] : " << tokens[ii] << endl;

// >>>>>>>>>>> Commande d'interpreteur
if (kw == "helpwindow") ShowHelpWindow();
else if (kw == "help") {
  if (tokens.size() > 0) {
    CmdExmap::iterator it = cmdexmap.find(tokens[0]);
    if (it == cmdexmap.end())  cout << "Nothing known about " << tokens[0] << " ?? " << endl;
    else cout << (*it).second.us << endl;
    }
  else {  
    cout << "\n -------- PIACmd::Interpret() ::::: Help ------------ \n";
    cout << ">>> Interpreter's keywords : \n";
    cout << "  timingon  timingoff traceon  traceoff \n";
    cout << "  set unset listvar listcommands exec shell \n";
    cout << "  > set varname 'string'   # To set a variable, $varname \n";
    cout << "  > unset varname          # clear variable definition \n";
    cout << "  > listvars   # List of variable names and values \n";
    cout << "  > listcommands # List of all known commands \n";
    cout << "  > exec filename  # Execute commands from file \n";
    cout << "  > shell comand_string  # Execute shell command \n";
    cout << "  > help <command_name>  # <command_name> usage info \n"; 
    cout << "  > helpwindow           # Displays help window \n" << endl;
    }
  }


else if (kw == "set") {
  if (tokens.size() < 2) { cout << "PIACmd::Interpret() Usage: set varname string" << endl;  return(0); }
  mVars[tokens[0]] = tokens[1];
  }
else if (kw == "unset") {
  if (tokens.size() < 1) { cout << "PIACmd::Interpret() Usage: unset varname" << endl;  return(0); }
  CmdVarList::iterator it = mVars.find(tokens[0]);
  if (it != mVars.end())  mVars.erase(it);
  else cerr << "PIACmd::Interpret() No variable with name " << tokens[0] << endl;
  }
else if (kw == "listvars") {
  cout << "PIACmd::Interpret()  Variable List , VarName = Value \n";
  CmdVarList::iterator it;
  for(it = mVars.begin(); it != mVars.end(); it++)  
    cout << (*it).first << " = " <<  (*it).second << "\n";
  cout << endl;
  }
else if (kw == "listvars") {
  cout << "---- PIACmd::Interpret()  Command keyword  List ----- \n";
  CmdExmap::iterator it;
  int kc = 0;
  for(it = cmdexmap.begin(); it != cmdexmap.end(); it++) {
    cout << (*it).first << "  ";
    kc++;
    if (kc >= 5) { cout << "\n"; kc = 0; }
    }
  cout << endl;
  }
else if (kw == "traceon")  { cout << "PIACmd::Interpret()  -> Trace ON mode " << endl; trace = true; }
else if (kw == "traceoff") { cout << "PIACmd::Interpret()  -> Trace OFF mode " << endl; trace = false; }
else if (kw == "timingon") { 
  cout << "PIACmd::Interpret()  -> Timing ON mode " << endl; 
  if (gltimer)   delete gltimer;   gltimer = new Timer("PIA-CmdInterpreter ");   timing = true; 
  }
else if (kw == "timingoff") { 
  cout << "PIACmd::Interpret()  -> Timing OFF mode " << endl; 
  if (gltimer)  delete gltimer;  gltimer = NULL;  timing = false; 
  }
else if (kw == "exec") {
  if (tokens.size() < 1) { cout << "PIACmd::Interpret() Usage: exec filename" << endl;  return(0); }
  ExecFile(tokens[0]);
  }
else if (kw == "shell") {
  if (tokens.size() < 1) { cout << "PIACmd::Interpret() Usage: shell cmdline" << endl;  return(0); }
  system(toks.c_str());
  }
//  Execution d'une commande enregistree
else {
  CmdExmap::iterator it = cmdexmap.find(kw);
  if (it == cmdexmap.end())  cout << "No such command : " << kw << " ! " << endl;
  else { 
    if ((*it).second.cex) (*it).second.cex->Execute(kw, tokens);
    else cout << "Dont know how to execute " << kw << " ? " << endl;
    }
  }

if (timing)  gltimer->Split();
return(0);
}


/* --Methode-- */
int PIACmd::ExecFile(string& file)
{
char line_buff[512];
FILE *fip;

if ( (fip = fopen(file.c_str(),"r")) == NULL ) {
  cerr << "PIACmd::Exec() Error opening file " << file << endl;
  hist << "##! PIACmd::Exec() Error opening file " << file << endl;
  return(0);
  }
 
hist << "### Executing commands from " << file << endl;
if (trace) { 
  mImgApp->GetConsole()->AddStr("### Executing commands from ", PIVA_Magenta);
  mImgApp->GetConsole()->AddStr(file.c_str(), PIVA_Magenta);
  mImgApp->GetConsole()->AddStr("\n", PIVA_Magenta);
  }

while (fgets(line_buff,511,fip) != NULL)
  {
  if (trace) mImgApp->GetConsole()->AddStr(line_buff, PIVA_Magenta);
  line_buff[strlen(line_buff)-1] = '\0';   /*  LF/CR de la fin */
  string line(line_buff);
  Interpret(line);
  }
hist << "### End of Exec( " << file << " ) " << endl;
if (trace) { 
  mImgApp->GetConsole()->AddStr("### End of Exec( ", PIVA_Magenta);
  mImgApp->GetConsole()->AddStr(file.c_str(), PIVA_Magenta);
  mImgApp->GetConsole()->AddStr(" ) \n", PIVA_Magenta);
  }

return(0);
}


static string* videstr = NULL;
/* --Methode-- */
string& PIACmd::GetUsage(const string& kw)
{
CmdExmap::iterator it = cmdexmap.find(kw);
if (it == cmdexmap.end()) {  
  if (videstr == NULL) videstr = new string("");
  return(*videstr);
  }
else return( (*it).second.us ); 
}

/* --Methode-- */
void PIACmd::ShowHelpWindow()
{
helpwin->Show();
}
