// This may look like C code, but it is really -*- C++ -*-
//  Adaptateur pour objets gere par   NamedObjMgr (piapp)
//                                    Reza 05/99
//  LAL-IN2P3/CNRS               CEA-DAPNIA      

#ifndef NOMGADAPTER_H_SEEN
#define NOMGADAPTER_H_SEEN

#include "machdefs.h"
#include "ppersist.h"
#include "anydataobj.h"
#include "pidrawer.h"
#include "parradapter.h"
#include "ntupintf.h"


// Classe d'adaptateur d'objets de donnees pour la gestion d'objets
// nommes (NamedObjMgr) de piapp

class NObjMgrAdapter {
public:
				NObjMgrAdapter(AnyDataObj* o);
  virtual			~NObjMgrAdapter();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  virtual AnyDataObj*		GetDataObj();

  virtual void			ReadFits(string const & flnm);
  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  virtual PIDrawer*		GetDrawer(string& dopt);
  virtual P2DArrayAdapter*	Get2DArray(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface();
protected:
  AnyDataObj* mObj;
};

#endif
