#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <typeinfo>
#include <iostream.h>
#include <string>
#include <list>
#include <map>
#if defined(__KCC__)
using std::string ;
#include <list.h>
#include <map.h>
#endif

#include "strutil.h"

#include "nobjmgr.h"
#include "servnobjm.h"
#include "pistdimgapp.h"

#include "histos.h"
#include "histos2.h"
#include "ntuple.h"
#include "hisprof.h"



/* --Methode-- */
Services2NObjMgr::Services2NObjMgr(PIStdImgApp* app, string& tmpdir)
{
TmpDir = tmpdir;
PDynLinkMgr::SetTmpDir(tmpdir);
mImgapp = app;
dynlink = NULL;
InitGrAttNames();
}
  
/* --Methode-- */
Services2NObjMgr::~Services2NObjMgr()
{
CloseDLL();
}

/* --Methode-- */
void Services2NObjMgr::RegisterClass(AnyDataObj* o, NObjMgrAdapter* oa)
{
ObjAdaptList::iterator it;
for(it = objadaplist.begin(); it != objadaplist.end(); it++) 
    if (typeid(*o) == typeid(*((*it).obj)))  THROW(dupIdErr);

dataobj_adapter oba;
oba.obj = o;
oba.obja = oa;
objadaplist.push_back(oba);
}

/* --Methode-- */
NObjMgrAdapter* Services2NObjMgr::GetAdapter(AnyDataObj* o)
{
ObjAdaptList::iterator it;
for(it = objadaplist.begin(); it != objadaplist.end(); it++) 
  if (typeid(*o) == typeid(*((*it).obj)))  return((*it).obja->Clone(o));
return(new NObjMgrAdapter(o));
}

/* --Methode-- */
void Services2NObjMgr::Nobj_ComputeExpressions(NObjMgrAdapter* obja, string& expx, string& expy, string& expz, 
                          string& expwt, string& expcut, NTuple* nt, Histo* h1, Histo2D* h2, HProf* hp)
{
if (obja == NULL) return;
NTupleInterface* objnt = obja->GetNTupleInterface();
if (objnt == NULL)  return;
string  vardec = objnt->VarList_C("_zz61qq_");

PlotExprFunc f = LinkExprFunc(vardec, expx, expy, expz, expwt, expcut);
if (!f) { 
  cerr << "NamedObjMgr_ComputeExpressions() Error Creation PlotExprFunc " <<  endl; 
  return;
  }

double xnt[10];
float  fxnt[10];

int i,j,k;
for(i=0; i<10; i++) xnt[i] = 0.;

TRY  {
  double* xn;
  for(k=0; k<objnt->NbLines(); k++)    {
    xn = objnt->GetLineD(k);
    if (f(xn, xnt, xnt+1, xnt+2, xnt+3) != 0) {
      if (nt) { 
         for(i=0; i<4; i++) fxnt[i] = xnt[i]; 
         nt->Fill(fxnt);
         }
      if (h1) h1->Add(xnt[0], xnt[3]);
      if (h2) h2->Add(xnt[0], xnt[1], xnt[3]);
      if (hp) hp->Add(xnt[0], xnt[1], xnt[3]);
      }
    }
 }
CATCH(merr) {
  fflush(stdout); 
  cout << endl; 
  cerr << endl;
  string es = PeidaExc(merr);
  cerr << "NamedObjMgr_ComputeExpressions()  Exception :" << merr << es;
  } ENDTRY;
 

// Fermeture du fichier .so 
CloseDLL();
return;
}


/* --Methode-- */
PlotExprFunc Services2NObjMgr::LinkExprFunc(string& vardec, string& expx, string& expy, string& expz, 
                                            string& expwt, string& cut)
{
FILE *fip;
string fname = TmpDir + "expf_pia_dl.c";
string fnamer = TmpDir + "expf_pia_dl";
string cmd;
int rc;

cmd = "rm -f " + fname;
rc = system(cmd.c_str());
//DBG printf("LinkExprFunc_Do> %s  (Rc=%d)\n", cmd.c_str(), rc); 

if ((fip = fopen(fname.c_str(), "w")) == NULL)   { 
  string sn = fname; 
  cout << "NamedObjMgr/LinkExprFunc_Erreur: Pb. Ouverture " << sn << endl; 
  return(NULL); 
  }

// constitution du fichier a compiler
fputs("#include <math.h> \n", fip);
fputs("int expf_pia_dl_func(double* _zz61qq_, double* _rx_61qq_, double* _ry_61qq_, double* _rz_61qq_, double* _wt_61qq_) \n{\n", fip);
fprintf(fip,"%s \n", vardec.c_str());
fprintf(fip, "if (!(%s)) { *_rx_61qq_ = *_ry_61qq_ = *_rz_61qq_ = *_wt_61qq_ = 0.;  return(0); } \n", cut.c_str());
fprintf(fip, "*_rx_61qq_ = %s ; \n", expx.c_str());
fprintf(fip, "*_ry_61qq_ = %s ; \n", expy.c_str());
fprintf(fip, "*_rz_61qq_ = %s ; \n", expz.c_str());
fprintf(fip, "*_wt_61qq_ = %s ; \n", expwt.c_str());
fputs("return(1); \n} \n", fip);
fclose(fip);

return((PlotExprFunc)LinkFunctionFromFile(fnamer, "expf_pia_dl_func"));
}


/* --Methode-- */
DlFunction Services2NObjMgr::LinkFunctionFromFile(string& fnamer, char* funcname)
{
string fname = fnamer + ".c" ;
string fnameobj = fnamer + ".o" ;
string fnameso = fnamer + ".so";

//  Le link dynamique
CloseDLL();
dynlink = PDynLinkMgr::BuildFromCFile(fname);
if (dynlink == NULL) { 
  cerr << "NamedObjMgr/LinkFunctionFromFile_Erreur: Erreur ouverture SO " << endl; 
  return(NULL); 
  }

DlFunction retfunc = dynlink->GetFunction(funcname);
if (retfunc == NULL) { 
  string sn = funcname; 
  cerr << "NamedObjMgr/LinkExprFunc_Erreur: Erreur linking " << sn << endl; 
  CloseDLL();
  return(NULL); 
  }
else return(retfunc);
}

/* --Methode-- */
void Services2NObjMgr::CloseDLL()
{
if (dynlink) delete dynlink;   dynlink = NULL;
}

/* --Methode-- */
string Services2NObjMgr::FileName2Name(string const & fn)
{

char fsep[2] = {FILESEP, '\0'};
char tsep[2] = {'.', '\0'};
size_t p = fn.find_last_of(fsep);
size_t l = fn.length();
if (p >= l)  p = 0;
else p++;
size_t q = fn.find_first_of(tsep,p);
if (q < p) q = l;
return(fn.substr(p,q-p));
}


typedef vector<string> GraTok;

/* --Methode-- */
int Services2NObjMgr::DecodeDispOption(string& gratt, bool& fgsrgr)
{
int ropt = Disp_Next;
if (!mImgapp)  return(ropt); 

for(int i=0; i<gratt.length(); i++) gratt[i] = tolower(gratt[i]);

if (fgsrgr) mImgapp->SaveGraphicAtt();

if (gratt.substr(0,3) == "def")  {  // Remise aux valeurs par defaut = non defini
  mImgapp->SetColAtt();
  mImgapp->SetLineAtt();
  mImgapp->SetFontAtt();
  mImgapp->SetMarkerAtt();
  mImgapp->SetColMapId();
  mImgapp->SetZoomAtt();
  return(ropt);
  }

// On separe en mots separes par des virgules 
gratt = ","+gratt;
size_t p = 0;
size_t q = 0;
size_t l = gratt.length();
string token;

GraTok grt;

while (q < l)  {
  p = gratt.find_first_not_of(" ,",q+1); // au debut d'un token
  if (p>=l) break;
  q = gratt.find_first_of(" ,",p); // la fin du token;
  token = gratt.substr(p,q-p);
  grt.push_back(token);
  }


static GrAttNames::iterator it;

int k; 
bool fgcont = true;
fgsrgr = false;

for(k=0; k<grt.size(); k++) {
//  cout << "--DBG--SetGraphicAttributes() " << grt[k] << endl;

 // Decodage option affichage (win, next, etc 
  fgcont = true;
  if ( (grt[k] == "win") || (grt[k] == "w") )  ropt =  Disp_Win;
  else if ( (grt[k] == "same") || (grt[k] == "s") )  ropt = Disp_Same;
  else  if ( (grt[k] == "stack") || (grt[k] == "st") )  ropt = Disp_Stack;
  else fgcont = false;
  if (fgcont)   continue;
  
  // Si c'est une couleur
  it = GrAcolors.find(grt[k]);
  if (it != GrAcolors.end())  { mImgapp->SetColAtt((PIColors)((*it).second.a1)); fgsrgr = true; continue; }
  // Si c'est un attribut de lignes
  it = GrAlines.find(grt[k]);
  if (it != GrAlines.end())  { mImgapp->SetLineAtt((PILineAtt)((*it).second.a1));  fgsrgr = true; continue; }
  // Si c'est un attribut de fontes
  it = GrAfonts.find(grt[k]);
  if (it != GrAfonts.end())  { mImgapp->SetFontAtt((PIFontSize)((*it).second.a2), (PIFontAtt)((*it).second.a1) ); 
                               fgsrgr = true;  continue; }
  // Si c'est un attribut de markers
  it = GrAmarkers.find(grt[k]);
  if (it != GrAmarkers.end())  { mImgapp->SetMarkerAtt((*it).second.a2, (PIMarker)((*it).second.a1) ); 
                                 fgsrgr = true;  continue; }
  // Si c'est un colormap
  it = GrAcmap.find(grt[k]);
  if (it != GrAcmap.end())  { mImgapp->SetColMapId( (CMapId)((*it).second.a1) ); fgsrgr = true; continue; }  
  // Si c'est un facteur de zoom
  it = GrAzoom.find(grt[k]);
  if (it != GrAzoom.end())  { mImgapp->SetZoomAtt( (*it).second.a1 );  fgsrgr = true; continue; }  
  // Si c'est un attribut d'axe
  it = GrAaxes.find(grt[k]);
  if (it != GrAaxes.end())  { mImgapp->SetAxesAtt( (*it).second.a1 );  fgsrgr = true; continue; }  
  
  }  

return(ropt);
}



// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Initialisation des chaines de caracteres designant les attributs graphiques 

/* --Methode-- */
void Services2NObjMgr::InitGrAttNames()
{
gratt_item gi;
// Les couleurs
gi.a2 = 0;
gi.a1 = PI_NotDefColor;
GrAcolors["defcol"] = gi;
gi.a1 = PI_Black;
GrAcolors["black"] = gi;
gi.a1 = PI_White;
GrAcolors["white"] = gi;
gi.a1 = PI_Grey;
GrAcolors["grey"] = gi;
gi.a1 = PI_Red;
GrAcolors["red"] = gi;
gi.a1 = PI_Blue;
GrAcolors["blue"] = gi;
gi.a1 = PI_Green;
GrAcolors["green"] = gi;
gi.a1 = PI_Yellow;
GrAcolors["yellow"] = gi;
gi.a1 = PI_Magenta;
GrAcolors["magenta"] = gi;

gi.a1 = PI_Cyan;
GrAcolors["cyan"] = gi;
gi.a1 = PI_Turquoise;
GrAcolors["turquoise"] = gi;
gi.a1 = PI_NavyBlue;
GrAcolors["navyblue"] = gi;
gi.a1 = PI_Orange;
GrAcolors["orange"] = gi;
gi.a1 = PI_SiennaRed;
GrAcolors["siennared"] = gi;
gi.a1 = PI_Purple;
GrAcolors["purple"] = gi;
gi.a1 = PI_LimeGreen;
GrAcolors["limegreen"] = gi;
gi.a1 = PI_Gold;
GrAcolors["gold"] = gi;

// Les attributs de lignes
gi.a2 = 0;
gi.a1 = PI_NotDefLineAtt;
GrAlines["defline"] = gi;
gi.a1 = PI_NormalLine;
GrAlines["normalline"] = gi;
gi.a1 = PI_ThinLine;
GrAlines["thinline"] = gi;
gi.a1 = PI_ThickLine;
GrAlines["thickline"] = gi;
gi.a1 = PI_DashedLine;
GrAlines["dashedline"] = gi;
gi.a1 = PI_ThinDashedLine;
GrAlines["thindashedline"] = gi;
gi.a1 = PI_ThickDashedLine;
GrAlines["thickdashedline"] = gi;
gi.a1 = PI_DottedLine;
GrAlines["dottedline"] = gi;
gi.a1 = PI_ThinDottedLine;
GrAlines["thindottedline"] = gi;
gi.a1 = PI_ThickDottedLine;
GrAlines["thickdottedline"] = gi;

// Les fontes 
gi.a2 = PI_NotDefFontSize;
gi.a1 = PI_NotDefFontAtt;
GrAlines["deffont"] = gi;

gi.a2 = PI_NormalSizeFont;
gi.a1 = PI_RomanFont;
GrAlines["normalfont"] = gi;
gi.a1 = PI_BoldFont;
GrAlines["boldfont"] = gi;
gi.a1 = PI_ItalicFont;
GrAlines["italicfont"] = gi;
gi.a2 = PI_SmallSizeFont;
gi.a1 = PI_RomanFont;
GrAlines["smallfont"] = gi;
gi.a1 = PI_BoldFont;
GrAlines["smallboldfont"] = gi;
gi.a1 = PI_ItalicFont;
GrAlines["smallitalicfont"] = gi;
gi.a2 = PI_BigSizeFont;
gi.a1 = PI_RomanFont;
GrAlines["bigfont"] = gi;
gi.a1 = PI_BoldFont;
GrAlines["bigboldfont"] = gi;
gi.a1 = PI_ItalicFont;
GrAlines["bigitalicfont"] = gi;
gi.a2 = PI_HugeSizeFont;
gi.a1 = PI_RomanFont;
GrAlines["hugefont"] = gi;
gi.a1 = PI_BoldFont;
GrAlines["hugeboldfont"] = gi;
gi.a1 = PI_ItalicFont;
GrAlines["hugeitalicfont"] = gi;


// Les markers 
const char* mrkn[11] = { "dotmarker", "plusmarker", "crossmarker", 
                         "circlemarker", "fcirclemarker", "boxmarker", "fboxmarker", 
                         "trianglemarker", "ftrianglemarker", "starmarker", "fstarmarker"};
PIMarker mrk[11] = { PI_DotMarker, PI_PlusMarker, PI_CrossMarker, 
                     PI_CircleMarker, PI_FCircleMarker, PI_BoxMarker, PI_FBoxMarker, 
                     PI_TriangleMarker, PI_FTriangleMarker, PI_StarMarker, PI_FStarMarker};

gi.a2 = 0;
gi.a1 = PI_NotDefMarker;
GrAmarkers["defmarker"] = gi;
 
for(int j=0; j<11; j++) {
  string smrk;
  char buff[16];
  for(int m=1; m<10; m+=2) {
    sprintf(buff,"%d",m);
    smrk = (string)mrkn[j] + (string)buff;
    gi.a1 = mrk[j];  gi.a2 = m;
    GrAmarkers[smrk] = gi;
    }
  }

// Les tables de couleurs 
gi.a2 = 0;
gi.a1 = CMAP_OTHER;
GrAcmap["defcmap"] = gi;
gi.a1 = CMAP_GREY32;
GrAcmap["grey32"] = gi;
gi.a1 = CMAP_GREYINV32;
GrAcmap["greyinv32"] = gi;
gi.a1 = CMAP_COLRJ32;
GrAcmap["colrj32"] = gi;
gi.a1 = CMAP_COLBR32;
GrAcmap["colbr32"] = gi;
gi.a1 = CMAP_GREY128;
GrAcmap["grey128"] = gi;
gi.a1 = CMAP_GREYINV128;
GrAcmap["greyinv128"] = gi;
gi.a1 = CMAP_COLRJ128;
GrAcmap["colrj128"] = gi;
gi.a1 = CMAP_COLBR128;
GrAcmap["colbr128"] = gi;

// La valeur de zoom
gi.a2 = 0;
gi.a1 = 0;
GrAzoom["defzoom"] = gi;
gi.a1 = 1;
GrAzoom["zoomx1"] = gi;
gi.a1 = 2;
GrAzoom["zoomx2"] = gi;
gi.a1 = 3;
GrAzoom["zoomx3"] = gi;
gi.a1 = 4;
GrAzoom["zoomx4"] = gi;
gi.a1 = 5;
GrAzoom["zoomx5"] = gi;
gi.a1 = -2;
GrAzoom["zoom/2"] = gi;
gi.a1 = -3;
GrAzoom["zoom/3"] = gi;
gi.a1 = -4;
GrAzoom["zoom/4"] = gi;
gi.a1 = -5;
GrAzoom["zoom/5"] = gi;

// Attributs d'axes
gi.a2 = 0;
gi.a1 = (int)(kBoxAxes | kExtTicks | kLabels);
GrAaxes["stdaxes"] = gi;
GrAaxes["defaxes"] = gi;
GrAaxes["boxaxes"] = gi;
gi.a1 = (int)kAxesDflt;
GrAaxes["simpleaxes"] = gi;
gi.a1 = (int)(kBoxAxes | kExtTicks | kLabels | kGridOn);
GrAaxes["boxaxesgrid"] = gi;

gi.a1 = (int)(kBoxAxes | kTicks | kLabels | kMinTicks | kMajTicks);
GrAaxes["fineaxes"] = gi;
 gi.a1 = (int)(kBoxAxes | kTicks | kLabels | kMinTicks | kMajTicks | kGridOn);
GrAaxes["grid"] = gi;
GrAaxes["fineaxesgrid"] = gi;
                
}
