#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream.h>
#include <string>

#include "nommatvecadapter.h"
#include "piscdrawwdg.h"
#include "pipodrw.h"

//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Vector 
//---------------------------------------------------------------

/* --Methode-- */
NOMAdapter_Vector::NOMAdapter_Vector(Vector* o)
  : NObjMgrAdapter(o)
{
mVec = o;
}

/* --Methode-- */
NOMAdapter_Vector::~NOMAdapter_Vector()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_Vector::Clone(AnyDataObj* o)
{
Vector* v = dynamic_cast<Vector *>(o);
if (v) return ( new NOMAdapter_Vector(v) );
return ( new NObjMgrAdapter(o) );
}


/* --Methode-- */
void NOMAdapter_Vector::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mVec->Write(pos,0,tag);
#else
string s = typeid(*mObj).name();
cout << "NOMAdapter_Vector::SavePPF() - Error : Not supported for " << s << endl;
#endif
}

/* --Methode-- */
void NOMAdapter_Vector::Print(ostream& os)
{
os << (*mVec);
}

/* --Methode-- */
PIDrawer* NOMAdapter_Vector::GetDrawer(string & dopt)
{
dopt = "thinline," + dopt;
return( new PIYfXDrawer( new POVectorAdapter(mVec, false), NULL, true) );
}

/* --Methode-- */
NTupleInterface* NOMAdapter_Vector::GetNTupleInterface()
{
return( new NTupInt_Vector(mVec) );
}


// -------------------------------------------------------------

/* --Methode-- */
NTupInt_Vector::NTupInt_Vector(Vector* v)
{
mVec = v;
}

/* --Methode-- */
NTupInt_Vector::~NTupInt_Vector()
{
}

/* --Methode-- */
uint_4 NTupInt_Vector::NbLines()
{
return(mVec->NElts());
}

/* --Methode-- */
uint_4 NTupInt_Vector::NbColumns()
{
return(2);
}

/* --Methode-- */
r_8* NTupInt_Vector::GetLineD(int n)
{
int i;
if ((n < 0) || (n >= mVec->NElts() )) 
    for(i=0; i<2; i++)  mRet[i] = 0.;
else { 
  mRet[0] = n;  mRet[1] = (*mVec)(n);
  }
return(mRet);
}

/* --Methode-- */
string NTupInt_Vector::VarList_C(const char* nx)
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double i,val; \n";
vardec += "i = " + nomx + "[0];  val = " + nomx + "[1]; \n";
return(vardec);
}


//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Matrix 
//---------------------------------------------------------------


/* --Methode-- */
NOMAdapter_Matrix::NOMAdapter_Matrix(Matrix* o)
  : NObjMgrAdapter(o)
{
mMtx = o;
}

/* --Methode-- */
NOMAdapter_Matrix::~NOMAdapter_Matrix()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_Matrix::Clone(AnyDataObj* o)
{
Matrix* m = dynamic_cast<Matrix *>(o);
if (m) return ( new NOMAdapter_Matrix(m) );
return ( new NObjMgrAdapter(o) );
}


/* --Methode-- */
void NOMAdapter_Matrix::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mMtx->Write(pos,0,tag);
#else
string s = typeid(*mObj).name();
cout << "NOMAdapter_Matrix::SavePPF() - Error : Not supported for " << s << endl;
#endif
}

/* --Methode-- */
void NOMAdapter_Matrix::Print(ostream& os)
{
os << (*mMtx);
}


/* --Methode-- */
P2DArrayAdapter* NOMAdapter_Matrix::Get2DArray(string &)
{
return ( new POMatrixAdapter(mMtx, false) );
}

/* --Methode-- */
NTupleInterface* NOMAdapter_Matrix::GetNTupleInterface()
{
return( new NTupInt_Matrix(mMtx) );
}



// -------------------------------------------------------------

/* --Methode-- */
NTupInt_Matrix::NTupInt_Matrix(Matrix* m)
{
mMtx = m;
}

/* --Methode-- */
NTupInt_Matrix::~NTupInt_Matrix()
{
}

/* --Methode-- */
uint_4 NTupInt_Matrix::NbLines()
{
return( mMtx->NRows()*mMtx->NCol() );
}

/* --Methode-- */
uint_4 NTupInt_Matrix::NbColumns()
{
return(3);
}

/* --Methode-- */
r_8* NTupInt_Matrix::GetLineD(int n)
{
int i,j;
if ((n < 0) || (n >= mMtx->NRows()*mMtx->NCol() )) 
    for(i=0; i<3; i++)  mRet[i] = 0.;
else { 
  i = n/mMtx->NCol(); j = n%mMtx->NCol(); 
  mRet[0] = i;  mRet[1] = j;  mRet[2] = (*mMtx)(i,j);
  }
return(mRet);
}

/* --Methode-- */
string NTupInt_Matrix::VarList_C(const char* nx)
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double i,j,val; \n";
vardec += "i = " + nomx + "[0]; j = " + nomx + "[1];  val = " + nomx + "[2]; \n";
return(vardec);
}
