#include <stdio.h>
#include <string.h>

#include "perrors.h"
#include "ntuple.h"


#define BADVAL -1.e19
#define LENNAME 8
#define LENNAME1  (LENNAME+1)

//++
// Class	NTuple
// Lib	Outils++ 
// include	ntuple.h
//
//	Classe de ntuples
//--

/* --Methode-- */
//++
NTuple::NTuple()
//
//	Createur par defaut
//--
{
mNVar = mNEnt = mBlk = mNBlk = 0;
mVar = NULL;
mVarD = NULL;
mNames = NULL;
mInfo = NULL;
}


//++
NTuple::NTuple(int nvar, char** noms, int blk)
//
//	Createur d'un ntuple de `nvar' variables dont les
//	noms sont dans le tableau de cahines de caracteres `noms'
//	avec `blk' d'evenements par blocks.
//--
{
mNVar = mNEnt = mBlk = mNBlk = 0;
mVar = NULL;
mVarD = NULL;
mNames = NULL;
mInfo = NULL;
if (nvar <= 0)  THROW(sizeMismatchErr); 
mNVar = nvar;
mVar = new r_4[nvar];
mVarD = new r_8[nvar];
if (blk < 10) blk = 10;
mBlk = blk;
// On prend des noms de LENNAME char pour le moment
mNames = new char[nvar*LENNAME1];
r_4* pt = new r_4[nvar*blk];
mNBlk = 1;
mPtr.push_back(pt);
int i;
for(i=0; i<nvar; i++)
  { strncpy(mNames+i*LENNAME1, noms[i], LENNAME);  
  mNames[i*LENNAME1+LENNAME] = '\0'; }
return;
}

/* --Methode-- */
//++
NTuple::NTuple(char *flnm)
//
//	Createur lecture fichier ppersist.
//--
{
mNVar = mNEnt = mBlk = mNBlk = 0;
mVar = NULL;
mVarD = NULL;
mNames = NULL;
mInfo = NULL;
PInPersist s(flnm);
Read(s);
}

/* --Methode-- */
NTuple::~NTuple()
{
Clean();
}

/* --Methode-- */
void NTuple::Clean()
{
if (mVar) delete[] mVar;
if (mVarD) delete[] mVarD;
if (mNames)  delete[] mNames;
if (mInfo) delete mInfo;
int i;
for(i=0; i<mNBlk; i++)  delete[] mPtr[i];
mPtr.erase(mPtr.begin(), mPtr.end());
mNVar = mNEnt = mBlk = mNBlk = 0;
mVar = NULL;
mVarD = NULL;
mNames = NULL;
return;
}

/* --Methode-- */
//++
void  NTuple::Fill(r_4* x)
//
//	Remplit le ntuple avec le tableau cd reels `x'.
//--
{
int numb = mNEnt/mBlk;
if (numb >= mNBlk) {
  r_4* pt = new r_4[mNVar*mBlk];
  mNBlk++;
  mPtr.push_back(pt);
}
int offb = mNEnt-numb*mBlk;
memcpy((mPtr[numb]+offb*mNVar), x, mNVar*sizeof(r_4));
mNEnt++;
return;
}


/* --Methode-- */
//++
float NTuple::GetVal(int n, int k)  const
//
//	Retourne la valeur de la variable `k' de l'evenement `n'.
//--
{
if (n >= mNEnt)   return(BADVAL);
if ( (k < 0) || (k >= mNVar) )    return(BADVAL);
int numb = n/mBlk;
int offb = n-numb*mBlk;
return(*(mPtr[numb]+offb*mNVar+k));
}


/* --Methode-- */
//++
int NTuple::IndexNom(const char* nom)  const
//
//	Retourne le numero de la variable de nom `nom'.
//--
{
int i;
for(i=0; i<mNVar; i++)  
  if ( strcmp(nom, mNames+i*LENNAME1) == 0)  return(i);
return(-1);
}


static char nomretour[2*LENNAME1];
/* --Methode-- */
//++
char* NTuple::NomIndex(int k)  const
//
//	Retourne le nom de la variable numero 'k'
//--
{
nomretour[0] = '\0';
if ((k >= 0) && (k < mNVar))  strcpy(nomretour, mNames+k*LENNAME1);
return(nomretour);
}

/* --Methode-- */
//++
string NTuple::VarList_C(const char* nomx)  const
//
//	Retourne une chaine de caracteres avec la declaration des noms de 
//	variables. si "nomx!=NULL" , des instructions d'affectation
//	a partir d'un tableau "nomx[i]" sont ajoutees. 
//--
{
string rets;
int i;
for(i=0; i<mNVar; i++) {
  if ( (i%5 == 0) && (i > 0) )  rets += ";";  
  if (i%5 == 0)   rets += "\ndouble "; 
  else rets += ",";
  rets += mNames+i*LENNAME1;
  }
rets += "; \n";
if (nomx) { 
  char buff[256];
  for(i=0; i<mNVar; i++) {
    sprintf(buff,"%s=%s[%d]; ",  mNames+i*LENNAME1, nomx, i);
    rets += buff;
    if ( (i%3 == 0) && (i > 0) )  rets += "\n"; 
    }
  }

return(rets);
}


  
/* --Methode-- */
//++
r_4* NTuple::GetVec(int n, r_4* ret)   const
//
//	Retourne l'evenement `n' dans le vecteur `ret'.
//--
{
int i;
if (ret == NULL)   ret = mVar;
if (n >= mNEnt) {
  for(i=0; i<mNVar; i++)   ret[i] = BADVAL;
  return(ret);
}
  
int numb = n/mBlk;
int offb = n-numb*mBlk;
memcpy(ret, (mPtr[numb]+offb*mNVar), mNVar*sizeof(r_4));
return(ret);
}

/* --Methode-- */
//++
r_8* NTuple::GetVecD(int n, r_8* ret)   const
//
//	Retourne l'evenement `n' dans le vecteur `ret'.
//--
{
int i;
if (ret == NULL)   ret = mVarD;
float *  fr = GetVec(n);
for(i=0; i<mNVar; i++)   ret[i] = fr[i];
return(ret);
}

/* --Methode-- */
//++
void  NTuple::GetMinMax(int k, float& min, float& max)  const
//
//	Retourne le minimum et le maximum de la variable `k'.
//--
{
min = 9.e19; max = -9.e19;
if ( (k < 0) || (k >= mNVar) )    return;
int jb,ib,i;
float x;
i=0;
for(jb=0; jb< mNBlk; jb++)
  for(ib=0; ib< mBlk; ib++) {
    if (i >= mNEnt)  break;
    i++;
    x = *(mPtr[jb]+ib*mNVar+k);
    if(i==1) {min = x; max = x;}
    if (x < min)  min = x;
    if (x > max)  max = x;
  }
return;
}

/* --Methode-- */
//++
DVList&  NTuple::Info()
//
//	Renvoie une rfrence sur l'objet DVList Associ
//--
{
if (mInfo == NULL)  mInfo = new DVList;
return(*mInfo);
}

/* --Methode-- */
//++
void  NTuple::Print(int num, int nmax)  const
//
//	Imprime `nmax' evenements a partir du numero `num'.
//--
{
int i,j;

printf("Num     ");
for(i=0; i<mNVar; i++)  printf("%8s ", mNames+i*LENNAME1);
putchar('\n');

if (nmax <= 0)  nmax = 1;
if (num < 0)  num = 0;
nmax += num;
if (nmax > mNEnt) nmax = mNEnt;
for(i=num; i<nmax; i++) {
  GetVec(i, NULL); 
  printf("%6d  ", i);  
  for(j=0; j<mNVar; j++)  printf("%8g ", (float)mVar[j]);
  putchar('\n');
}
return;
}

/* --Methode-- */
//++
void  NTuple::Show(ostream& os)  const
//
//	Imprime l'information generale sur le ntuple.
//--
{
os << "NTuple: NVar= " << mNVar << " NEnt=" << mNEnt  
   << " (Blk Sz,Nb= " << mBlk << " ," << mNBlk << ")\n";
os << "            Variables       Min      Max       \n";
int i;
float min, max;
char buff[128];
for(i=0; i<mNVar; i++) {
  GetMinMax(i, min, max);
  sprintf(buff, "%3d  %16s  %10g  %10g \n", i, mNames+i*LENNAME1, min, max);
  os << (string)buff ;
  }
os << endl;
}


/* --Methode-- */
//++
void  NTuple::WriteSelf(POutPersist& s)  const
//
//	Ecriture ppersist du ntuple.
//--
{
char strg[256];
if (mInfo)  sprintf(strg, "NVar=%6d  NEnt=%9d  BlkSz=%6d NBlk=%6d  HasInfo", 
                          (int)mNVar, (int)mNEnt, (int)mBlk, (int)mNBlk);
else sprintf(strg, "NVar=%6d  NEnt=%9d  BlkSz=%6d NBlk=%6d ", 
                   (int)mNVar, (int)mNEnt, (int)mBlk, (int)mNBlk);
s.PutLine(strg);
s.PutI4(mNVar);
s.PutBytes(mNames, mNVar*LENNAME1);
s.PutI4(mNEnt);
s.PutI4(mBlk);
s.PutI4(mNBlk);
if (mInfo)  s << (*mInfo);
int jb;
for(jb=0; jb<mNBlk; jb++)
  s.PutR4s(mPtr[jb], mNVar*mBlk); 
return;
}

/* --Methode-- */
//++
void  NTuple::ReadSelf(PInPersist& s)
//
//	Lecture ppersist du ntuple.
//--
{

Clean();

char strg[256];
s.GetLine(strg, 255);
// Pour savoir s'il y avait un DVList Info associe
bool hadinfo = false;
if (strncmp(strg+strlen(strg)-7, "HasInfo", 7) == 0)  hadinfo = true;

s.GetI4(mNVar);
mNames = new char[mNVar*LENNAME1];
mVar = new r_4[mNVar];
mVarD = new r_8[mNVar];
s.GetBytes(mNames, mNVar*LENNAME1);
s.GetI4(mNEnt);
s.GetI4(mBlk);
s.GetI4(mNBlk);

if (hadinfo) {    // Lecture eventuelle du DVList Info
  if (mInfo == NULL)  mInfo = new DVList;
  s >> (*mInfo);
  }

int jb; 
for(jb=0; jb<mNBlk; jb++) {
  r_4* pt = new r_4[mNVar*mBlk];
  mPtr.push_back(pt);
  s.GetR4s(mPtr[jb], mNVar*mBlk); 
}

}
