#ifndef PICMAPBASE_H_SEEN
#define PICMAPBASE_H_SEEN

#include "pisysdep.h"
#include <string>
#include <string.h>


enum CMapId
 {
 CMAP_OTHER       = 0, 
 CMAP_GREY32      = 1,     // 32 niveaux de gris                    * permanent
 CMAP_GREYINV32   = 2,     // 32 niveaux gris du blan au noir       * permanent
 CMAP_COLRJ32     = 3,     // 32 couleurs, du Rouge au Jaune/blanc  * permanent
 CMAP_COLBR32     = 4,     // 32 couleurs du bleu au rouge
 CMAP_COLRV32     = 5,     // 32 couleurs 
 CMAP_COL16       = 6     // 16 Couleurs Arcenciel
 };
 

 
struct PIColor {
  unsigned short red;
  unsigned short green;
  unsigned short blue;
};

class PIColorMapGen {
public:
  PIColorMapGen(CMapId);
  PIColorMapGen(string const& nom, int nCol);  // CMapId : CMAP_OTHER automatiquement
  virtual ~PIColorMapGen();

  CMapId Type() const       {return mType;}
  int NCol() const          {return mNCol;}
  string const& Nom() const {return mNom;}

  virtual PIColor GetColor(int n)=0;
  virtual void AllocColor(PIColor const& col, int index)=0;
  virtual void FreeColors()=0;     // Desalloue les couleurs
protected:
  PIColorMapGen(CMapId, int);      // Fait une veritable allocation
  virtual void MakeColMap();       // Alloue la table de couleurs en appelant AllocColor
  void CopyFromGen(PIColorMapGen*);
  virtual void CopyFrom(PIColorMapGen*)=0;
  
  static int nCols[6];
  static char* noms[6];
  
  static PIColorMapGen* maps[4];

  int    mNCol;
  CMapId mType;
  string mNom;
  
};


#endif
