// $Id: tvector.cc,v 1.2 1999-05-18 12:23:15 ansari Exp $
//                         C.Magneville          04/99
#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <complex>
#include "pexceptions.h"
#include "tvector.h"
#include "objfio.h"
#include "generalfit.h"

using namespace PlanckDPC;

template <class T>
TVector<T>::TVector(uint_4 n)
// Constructeur d'un vecteur de "n" elements
: TMatrix<T>(n,1)
{
}

template <class T>
TVector<T>::TVector(uint_4 n, T* values,Bridge* br)
// Construit un vecteur de n elements. On fournit
// le tableau des valeurs et eventuellement un Bridge.
: TMatrix<T>(n,1,values,br)
{
}

template <class T>
TVector<T>::TVector(const TVector<T>& v)
// Constructeur par copie (partage si "v" temporaire).
: TMatrix<T>(v)
{
}

template <class T>
TVector<T>::TVector(const TVector<T>& v,bool share)
// Constructeur par copie avec possibilite de forcer le partage ou non.
: TMatrix<T>(v,share)
{
}

template <class T>
TVector<T>::TVector(const TMatrix<T>& a)
// Constructeur a partir d'une matrice "a" de dimension (n,1)
: TMatrix<T>(a)
{
if(a.NCols() != 1)
  throw(SzMismatchError("TVector(const TMatrix<T>& a) size mismatch, ncol!=1"));
}

//////////////////////////////////////////////////////////
//**** Residus des fits
TVector<r_8> TVector<r_8>::FitResidus(GeneralFit& gfit,double xorg,double dx)
// Retourne une classe contenant les residus du fit ``gfit''.
// La coordonnee de l'element (i) est -> x = xorg + i*dx
{
if(NElts()<=0)
  throw(SzMismatchError("TVector::FitResidus size mismatch\n"));
GeneralFunction* f = gfit.GetFunction();
if(f==NULL)
  throw(NullPtrError("TVector::FitResidus GeneraFit==NULL\n"));
int npar =  gfit.GetNPar();
if(npar==0)
  throw(SzMismatchError("TVector::FitResidus GeneraFit 0 parametre\n"));
double* par = new double[npar];
{for(int i=0;i<npar;i++) par[i] = gfit.GetParm(i);}
TVector<r_8> v(*this);
for(int i=0;i<NElts();i++) {
  double x = xorg+i*dx;
  v(i) -= f->Value(&x,par);
}
delete [] par;
return v;
}

TVector<r_8> TVector<r_8>::FitFunction(GeneralFit& gfit,double xorg,double dx)
// Retourne une classe contenant la fonction du fit ``gfit''.
// La coordonnee de l'element (i) est -> x = xorg + i*dx
{
if(NElts()<=0)
  throw(SzMismatchError("TVector::FitFunction size mismatch\n"));
GeneralFunction* f = gfit.GetFunction();
if(f==NULL)
  throw(NullPtrError("TVector::FitFunction GeneraFit==NULL\n"));
int npar =  gfit.GetNPar();
if(npar==0)
  throw(SzMismatchError("TVector::FitFunction GeneraFit 0 parametre\n"));
double* par = new double[npar];
{for(int i=0;i<npar;i++) par[i] = gfit.GetParm(i);}
TVector<r_8> v(*this);
for(uint_4 i=0;i<NElts();i++) {
  double x = xorg+i*dx;
  v(i) = f->Value(&x,par);
}
delete [] par;
return v;
}

///////////////////////////////////////////////////////////////
#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template TVector<uint_1>
#pragma define_template TVector<uint_2>
#pragma define_template TVector<int_2>
#pragma define_template TVector<int_4>
#pragma define_template TVector<int_8>
#pragma define_template TVector<uint_4>
#pragma define_template TVector<uint_8>
#pragma define_template TVector<r_4>
#pragma define_template TVector<r_8>
#pragma define_template TVector< complex<float> > 
#pragma define_template TVector< complex<double> > 
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
template class TVector<uint_1>;
template class TVector<uint_2>;
template class TVector<int_2>;
template class TVector<int_4>;
template class TVector<int_8>;
template class TVector<uint_4>;
template class TVector<uint_8>;
template class TVector<r_4>;
template class TVector<r_8>;
template class TVector< complex<float> >;
template class TVector< complex<double> >;
#endif
