// Classe d'initialisation du module Outils++ 
#include "sopnamsp.h"
#include "machdefs.h"
#include "skymapinit.h" 

#include <unistd.h>
#include "spherethetaphi.h"
#include "fiospherehealpix.h"
#include "fiospherethetaphi.h"
#include "fiolocalmap.h"
#include "fiosphereecp.h"
 
/*!
   \defgroup SkyMap SkyMap module
   This module contains classes for handling partial and full sky (spherical) maps
*/

/*!
  \class SOPHYA::SkyMapInitiator
  \ingroup SkyMap
  Class handling initialization for module SkyMap
*/

int SkyMapInitiator::FgInit = 0;

// Module version number - 1.6, Jul 06
#define MOD_VERS   1.6 

SkyMapInitiator::SkyMapInitiator()
  : SophyaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du module SkyMap
  
  // ---------- Les SphereThetaPhi ---------

  PPRegister(FIO_SphereCoordSys);
  DObjRegister(FIO_SphereCoordSys, SphereCoordSys);

  PPRegister(FIO_SphereThetaPhi<int_4>);
  DObjRegister(FIO_SphereThetaPhi<int_4>, SphereThetaPhi<int_4>);

  PPRegister(FIO_SphereThetaPhi<r_4>);
  DObjRegister(FIO_SphereThetaPhi<r_4>, SphereThetaPhi<r_4>);

  PPRegister(FIO_SphereThetaPhi<r_8>);
  DObjRegister(FIO_SphereThetaPhi<r_8>, SphereThetaPhi<r_8>);

  PPRegister(FIO_SphereThetaPhi< complex<r_4> >);
  DObjRegister(FIO_SphereThetaPhi< complex<r_4> >, SphereThetaPhi< complex<r_4> >);

  PPRegister(FIO_SphereThetaPhi< complex<r_8> >);
  DObjRegister(FIO_SphereThetaPhi< complex<r_8> >, SphereThetaPhi< complex<r_8> >);


  // ---------- Les SphereHEALPix ---------

  PPRegister(FIO_SphereHEALPix<uint_2>);  
  DObjRegister(FIO_SphereHEALPix<uint_2>, SphereHEALPix<uint_2>);

  PPRegister(FIO_SphereHEALPix<int_4>);  
  DObjRegister(FIO_SphereHEALPix<int_4>, SphereHEALPix<int_4>);

  PPRegister(FIO_SphereHEALPix<r_4>);  
  DObjRegister(FIO_SphereHEALPix<r_4>, SphereHEALPix<r_4>);

  PPRegister(FIO_SphereHEALPix<r_8>);
  DObjRegister(FIO_SphereHEALPix<r_8>, SphereHEALPix<r_8>);

  PPRegister(FIO_SphereHEALPix< complex<r_4> >);
  DObjRegister(FIO_SphereHEALPix< complex<r_4> >, SphereHEALPix< complex<r_4> >);

  PPRegister(FIO_SphereHEALPix< complex<r_8> >);
  DObjRegister(FIO_SphereHEALPix< complex<r_8> >, SphereHEALPix< complex<r_8> >);

  // ------------ Les LocalMap ---------
  PPRegister(FIO_LocalMap<int_4>);
  DObjRegister(FIO_LocalMap<int_4>, LocalMap<int_4>);

  PPRegister(FIO_LocalMap<r_4>);
  DObjRegister(FIO_LocalMap<r_4>, LocalMap<r_4>);

  PPRegister(FIO_LocalMap<r_8>);
  DObjRegister(FIO_LocalMap<r_8>, LocalMap<r_8>);

  PPRegister(FIO_LocalMap< complex<r_4> >);
  DObjRegister(FIO_LocalMap< complex<r_4> >, LocalMap< complex<r_4> >);

  PPRegister(FIO_LocalMap< complex<r_8> >);
  DObjRegister(FIO_LocalMap< complex<r_8> >, LocalMap< complex<r_8> >);

  // ---------- Les SphereECP ---------

  PPRegister(FIO_SphereECP<int_4>);
  DObjRegister(FIO_SphereECP<int_4>, SphereECP<int_4>);

  PPRegister(FIO_SphereECP<r_4>);
  DObjRegister(FIO_SphereECP<r_4>, SphereECP<r_4>);

  PPRegister(FIO_SphereECP<r_8>);
  DObjRegister(FIO_SphereECP<r_8>, SphereECP<r_8>);

  PPRegister(FIO_SphereECP< complex<r_4> >);
  DObjRegister(FIO_SphereECP< complex<r_4> >, SphereECP< complex<r_4> >);

  PPRegister(FIO_SphereECP< complex<r_8> >);
  DObjRegister(FIO_SphereECP< complex<r_8> >, SphereECP< complex<r_8> >);

  SophyaInitiator::RegisterModule("SkyMap", MOD_VERS);  // Module name and version number registration
}

SkyMapInitiator::~SkyMapInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static SkyMapInitiator s_sskymapinit_;

 
