// Classe d'initialisation du module FitsIOServer

#include "sopnamsp.h"
#include "machdefs.h"
#include "fiosinit.h"
#include "fitsmanager.h"
#include "fitshdtable.h"
#include "fitsarrhand.h"

#include "fitsntuple.h"
#include "fitsspherehealpix.h"
#include "fitsspherethetaphi.h"
#include "fitslocalmap.h"


#include <iostream> 

/*! 
  \class SOPHYA::FitsIOServerInitiator
  \ingroup FitsIOServer
  Perform registration of fits handlers.
  \sa SOPHYA::FitsManager
 */
int FitsIOServerInitiator::FgInit = 0;

// Module version number - 2.0 , Jul 2006
#define MOD_VERS   2.0 

FitsIOServerInitiator::FitsIOServerInitiator()
  : SophyaInitiator()
{
  FitsIOServerInitiator::FgInit++;
  if (FitsIOServerInitiator::FgInit > 1)  return;

//   Enregistrement des classes FitsHandler
  //DBG   cout << " ---- FitsIOServerInitiator / DEBUG ---- debut RegisterHandler " << endl;
  FitsManager::RegisterHandler(new FitsArrayHandler<int_2> , 1, "TArray<int_2>");
  FitsManager::RegisterHandler(new FitsArrayHandler<int_4> , 1, "TArray<int_4> ");
  FitsManager::RegisterHandler(new FitsArrayHandler<r_4> , 1, "TArray<r_4>");
  FitsManager::RegisterHandler(new FitsArrayHandler< r_8 > , 1, "TArray<r_8>");

  FitsManager::RegisterHandler(new FitsHandler<BaseDataTable>, 1, "DataTable");

  // Enregistrement des classes heritant de FitsIOHandler
  FitsManager::RegisterHandler(new FITS_NTuple, 0, "NTuple");
  
  FitsManager::RegisterHandler(new FITS_SphereHEALPix<r_4> , 0, "SphereHEALPix<r_4>");
  FitsManager::RegisterHandler(new FITS_SphereHEALPix<r_8> , 0, "SphereHEALPix<r_8>");
  FitsManager::RegisterHandler(new FITS_SphereHEALPix<int_4> , 0, "SphereHEALPix<int_4>");

  FitsManager::RegisterHandler(new FITS_SphereThetaPhi<r_4> , 0, "SphereThetaPhi<r_4>");
  FitsManager::RegisterHandler(new FITS_SphereThetaPhi<r_8> , 0, "SphereThetaPhi<r_8>");
  FitsManager::RegisterHandler(new FITS_SphereThetaPhi<int_4> , 0, "SphereThetaPhi<int_4>");

  FitsManager::RegisterHandler(new FITS_LocalMap<r_4> , 0, "LocalMap<r_4>");
  FitsManager::RegisterHandler(new FITS_LocalMap<r_8> , 0, "LocalMap<r_8>");
  FitsManager::RegisterHandler(new FITS_LocalMap<int_4> , 0, "LocalMap<int_4>");

  //DBG  cout << " ---- FitsIOServerInitiator / DEBUG ---- ListHandlers() : " << endl;
  //DBG  FitsManager::ListHandlers();

  SophyaInitiator::RegisterModule("FitsIOServer", MOD_VERS);  // Module name and version number registration
}

FitsIOServerInitiator::~FitsIOServerInitiator()
{
  FitsIOServerInitiator::FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques  
static FitsIOServerInitiator s_fios_init_;

