// This may look like C code, but it is really -*- C++ -*-
// Class DataTable  (Row-Column data table in memory) 
//   R. Ansari -  Avril 2005
//   (C)  LAL-IN2P3/CNRS    CEA-DAPNIA  

#ifndef SWPPFDTABLE_H_SEEN
#define SWPPFDTABLE_H_SEEN

#include "basedtable.h"
#include "swsegdb.h"
#include "ppfswapper.h"
#include "objfio.h"


namespace SOPHYA {

//! An implementation of BaseDataTable with using a PPF stream as swap space.
class SwPPFDataTable : public BaseDataTable {
public:
  SwPPFDataTable(sa_size_t segsz=512);
  SwPPFDataTable(POutPersist & os, sa_size_t segsz=512); 
  SwPPFDataTable(SwPPFDataTable const& a); 

  virtual ~SwPPFDataTable();

  virtual sa_size_t AddColumn(FieldType ft, string const & cnom);

  // Filling data structures (adding lines/rows)
  virtual sa_size_t AddRow(const r_8* data);
  virtual sa_size_t AddRow(const MuTyV * data);
  virtual sa_size_t AddRow(DataTableRow const& data);

  //! Equal (copy) operator - Copies the data and the structure if necessary from \b a   
  inline  SwPPFDataTable& operator = (BaseDataTable const& a) 
  { CopyMerge(a, true) ; return *this ; } 
  //! Equal (copy) operator - Copies the structure and shares the data \b a   
  inline SwPPFDataTable&  operator = (SwPPFDataTable const& a) 
  { Clear(); Share(a); return *this ; } 

  //  Pour la gestion de persistance PPF
  friend class ObjFileIO<BaseDataTable> ;
  
  //! Reset(Clear) the table content and structure
  virtual void Clear();
  /*! This method should be called in order to empty the swapout buffer, 
     before saving object to PPF stream 
  */
  void SwapOutAll() const;
protected:
  SwPPFDataTable(PInPersist & is, sa_size_t segsz); 
  void Share(SwPPFDataTable const & a);

  // Donnees en memoire
  std::vector< SwSegDataBlock<int_4> > mICols; 
  PPFDataSwapper<int_4> mISwapper;
  std::vector< SwSegDataBlock<int_8> > mLCols; 
  PPFDataSwapper<int_8> mLSwapper;
  std::vector< SwSegDataBlock<r_4> > mFCols;
  PPFDataSwapper<r_4> mFSwapper;
  std::vector< SwSegDataBlock<r_8> > mDCols; 
  PPFDataSwapper<r_8> mDSwapper;
  std::vector< SwSegDataBlock< complex<r_4> > > mYCols;
  PPFDataSwapper< complex<r_4> > mYSwapper;
  std::vector< SwSegDataBlock< complex<r_8> > > mZCols;
  PPFDataSwapper< complex<r_8> > mZSwapper;
  std::vector< SwSegDataBlock<string> > mSCols;    
  PPFDataSwapper<string> mSSwapper;
 
  // Output swap stream doit etre cree avant l'appel au constructeur
  // et rester valide (non detruit) tant que l'objet SwPPFDataTable existe
  POutPersist* mSwOut;   
  // Input swap stream - On cree un input swap stream et on fait 
  // un comptage de reference pour le detruire lorsque tous les tables
  // l'utilisant sont supprimes
  //! \cond    Pour NE PAS inclure dans la doc
  typedef struct { PInPersist* pis; uint_4 refcnt; } St_InSwap; 
  //! \endcond 
  St_InSwap * mSwIn;
}; 
  
/*! Writes the object in the POutPersist stream \b os */
inline POutPersist& operator << (POutPersist& os, SwPPFDataTable & obj)
{ obj.SwapOutAll();  ObjFileIO<BaseDataTable> fio(&obj);  fio.Write(os);  return(os); }
/*! Reads the object from the PInPersist stream \b is */
inline PInPersist& operator >> (PInPersist& is, SwPPFDataTable & obj)
{  ObjFileIO<BaseDataTable> fio(&obj); is.SkipToNextObject(); fio.Read(is); return(is); }

} // namespace SOPHYA

#endif

