#ifndef FITSSPHERETHETAPHI_SEEN
#define FITSSPHERETHETAPHI_SEEN


// Guy Le Meur 10/2001


#include "spherethetaphi.h"
#include "anydataobj.h"
#include "fitsfile.h"
namespace SOPHYA {
///////////////////////////////////////////////////////////////////////
// ------------- Classe pour la gestion de persistance I/O format fits--
// spherethetaphi
//////////////////////////////////////////////////////////////////////
template <class T>
class FITS_SphereThetaPhi : public FitsIOHandler  
{
public:

FITS_SphereThetaPhi();
FITS_SphereThetaPhi(char inputfile[],int hdunum=0); 
FITS_SphereThetaPhi(const SphereThetaPhi<T>& obj);
FITS_SphereThetaPhi(SphereThetaPhi<T>* obj);
virtual ~FITS_SphereThetaPhi();
virtual AnyDataObj* DataObj();
virtual void        SetDataObj(AnyDataObj & o);

virtual int         CheckHandling(AnyDataObj & o) ;
virtual int         CheckReadability(FitsInOutFile& is);
virtual FitsHandlerInterface* Clone();

void Mollweide_picture_projection(char flnm[]);
void sinus_picture_projection(char flnm[]);


inline operator SphereThetaPhi<T>() { return(*dobj_); }


protected:

virtual void ReadFromFits(FitsInFile& is);
virtual void WriteToFits(FitsOutFile& os) ;
SphereThetaPhi<T>* dobj_;
bool ownobj_;



};


//////////////////////////////////////////////////////////////////

template <class T>
inline FitsInOutFile& operator << (FitsInOutFile& fios, SphereThetaPhi<T> & sph)
  { FITS_SphereThetaPhi<T> fih(&sph); fih.Write(fios); return (fios); }

template <class T>
inline FitsInOutFile& operator >> (FitsInOutFile& fiis, SphereThetaPhi<T> & sph)
  { FITS_SphereThetaPhi<T> fih(&sph); fih.Read(fiis); return (fiis); }



} // Fin du namespace


#endif
