#ifndef FITSHISTOHAND_H
#define FITSHISTOHAND_H

#include "machdefs.h"
#include <string>
#include "histos.h"
#include "histos2.h"

#include "fitshandler.h"

namespace SOPHYA {

/*! 
  \ingroup FitsIOServer
  \brief FITS I/O handler for Histo/HProf and HistErr objects
*/

inline FitsInOutFile& operator << (FitsInOutFile& os, Histo const & obj)
{ FitsHandler<Histo> fio(const_cast<Histo &>(obj));  fio.Write(os);  return os; }

inline FitsInOutFile& operator >> (FitsInOutFile& is, Histo & obj)
  { FitsHandler<Histo> fio(obj); is.SkipEmptyFirstHDU();
  fio.Read(is); is.MoveToNextHDU(); return(is); }

/*! 
  \ingroup FitsIOServer
  \brief FITS I/O handler for Histo2D objects
*/

inline FitsInOutFile& operator << (FitsInOutFile& os, Histo2D const & obj)
{ FitsHandler<Histo2D> fio(const_cast<Histo2D &>(obj));  fio.Write(os);  return os; }

inline FitsInOutFile& operator >> (FitsInOutFile& is, Histo2D & obj)
  { FitsHandler<Histo2D> fio(obj); is.SkipEmptyFirstHDU();
  fio.Read(is); is.MoveToNextHDU(); return(is); }


} // Fin du namespace

#endif
