#!/bin/csh

cd ./code/
set mk = ../MakeMinuit
rm -f $mk
touch $mk

set src = ( *.F )
set obj
foreach f ( $src )
  set obj = ( $obj ${f:r}.o )
end

echo 'include $(SOPHYABASE)/include/sophyamake.inc' >> $mk
echo '' >> $mk
echo 'OBJMINUIT = '${obj} >> $mk
echo '' >> $mk
echo 'all: include libminuit.a' >> $mk
echo '' >> $mk
echo 'include:' >> $mk
echo '	rm -f minuit' >> $mk
echo '	ln -f -s ../minuit minuit' >> $mk
echo '' >> $mk
echo 'clean:' >> $mk
echo '	rm -f $(OBJMINUIT)' >> $mk
echo '	rm -f libminuit.a minuit' >> $mk
echo '	rm -f ../examples/minuit ../examples/minexam ../examples/minexam.o ../examples/fcnk0.o' >> $mk
echo '' >> $mk
echo 'libminuit.a : $(OBJMINUIT)' >> $mk
echo '	$(AR) $(ARFLAGS) $@ $(OBJMINUIT)' >> $mk
echo '' >> $mk
foreach f ( $obj )
  set c = ${f:r}.F
  echo "${f}: ${c}" >> $mk
  echo '	$(FCCOMPILE) -o $@' $c >> $mk
  echo '' >> $mk
end
echo 'test:' >> $mk
echo '	cd ../examples/; \' >> $mk
echo '	rm -f minuit minexam minexam.o fcnk0.o; \' >> $mk
echo '	ln -f -s ../minuit minuit; \' >> $mk
echo '	$(FCCOMPILE) -O -o fcnk0.o fcnk0.F; \' >> $mk
echo '	$(FCCOMPILE) -O -o minexam.o minexam.F; \' >> $mk
echo '	$(FCLINK) -O -o minexam minexam.o fcnk0.o -L../code/ -lminuit' >> $mk

exit 0
