#ifndef TOIITER_H
#define TOIITER_H


#include <vector>
#include <set>
#include <string>
#include "archeopsfile.h"

enum TOIKind {
  boloTens,   // tension en microVolts, filtree avec filtre carre indexe par bolometre
  boloRaw,    // tension brute, non filtree indexe par bolometre
  longitude,  // ballon
  latitude,   // ballon
  azimut,     // a preciser, reconstruit SST, magneto, autres...
  
  alpha,      // sur le ciel, indexe par bolometre
  delta       // sur le ciel, indexe par bolometre
  
};



class TOIIter {
public:
   TOIIter(TOIIter const&);
   ~TOIIter();
   bool Next();
   
   double getTime();                // MJD 
   double getValue(int column);
   bool   newValue(int column);     // a juste change ?
   bool   extendValue(int column);  // une valeur plus ancienne, etendue ?
   bool   interpValue(int column);  // une valeur interpolee avec valeur future ?
   TOIKind getKind(int column);
   int     getIndex(int column);    // si plusieurs, exemple, tension bolo 2
   
   int    getSampleIndex();         // numero d'echantillon dans dernier bloc bolo

   block_type_param*         lastParam();  
   block_type_journal*       lastJournal();
   block_type_reglage*       lastReglage();
   block_type_dilution*      lastDilution();
   block_type_gps*           lastGPS();
   block_type_une_periode*   lastUnePeriode();
   block_type_synchro_sol*   lastSynchroSol();
   block_type_pointage_sol*  lastPointageSol();
   block_type_bolo*          lastBolo();   
   block_type_gyro*          lastGyro();
   block_type_sst*           lastSST();
   block_type_bolo_comprime* lastBoloComp();   
   block_type_gyro_comprime* lastGyroComp();
   block_type_sst_comprime*  lastSSTComp();

protected:
   TOIIter();
   void Init(); // After setting the options, opens the first file.
   
   bool NextFile();
   
   ArcheopsFile* file;
   string directory;   // If several files to be read
   string fileName;    // If only one file to be read
   set<string> files;  // list of files in the directory...
   set<string>::iterator curFile;
   
   int imes;
   
   double tStart, tEnd;
   
   double tBlock0;  // MJD du bloc numero zero...
   
   struct info {
     TOIKind kind;
     int index;
     bool triggering;
     bool interpolated;
   };
   
   long trigMask;
   
   vector<info>   infos;
   
   friend class TOISvr;
   
   private:
};

#endif
