/* $Id: opendir.c,v 1.1.1.1 1999-05-25 08:25:53 ansari Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "dirent.h"

#include <Files.h>
#include <TextUtils.h>

#include "errno.h"

#define FALSE 0
#define ENOENT          2               /* No such file or directory */
#define EIO             5               /* I/O error */


DIR *opendir(char const * path)
{
	CInfoPBRec cipbr;
	HFileInfo *fpb = (HFileInfo*)&cipbr;
	DirInfo *dpb = (DirInfo*)&cipbr;
	DIR *dp;
	char name[FILENAME_MAX];
	short err;
	FSSpec tempspec;
	
	strncpy(name, path, sizeof(name)-1);
	c2pstr(name);
	
	err = FSMakeFSSpec(0,0,(unsigned char*)name,&tempspec);
	
	fpb->ioNamePtr= (unsigned char*)name;
	fpb->ioVRefNum= 0;
	fpb->ioFDirIndex= 0;
	fpb->ioFVersNum= 0;
	dpb->ioDrDirID= 0;
	err= PBGetCatInfo(&cipbr, FALSE);
	if (err != noErr) {
		errno = ENOENT;
		return NULL;
	}
	dp = (DIR*)calloc(1, sizeof(DIR));
	if (dp != NULL) {
		dp->volrefnum = tempspec.vRefNum;
		dp->dirid = fpb->ioDirID;
		dp->nextfile = 1;
	}
	return dp;
}

/*
 * Close a directory.
 */

int closedir(DIR *dp)
{
	free(dp);
	return 0;
}

/*
 * Read the next directory entry.
 */

struct dirent *readdir(DIR *dp)
{
	CInfoPBRec cipbr;
	HFileInfo *fpb = (HFileInfo*)&cipbr;
	DirInfo *dpb = (DirInfo*)&cipbr;
	short err;
	static struct dirent dir;

	fpb->ioDirID= dp->dirid;
	fpb->ioNamePtr= (unsigned char*)dir.d_name;
	fpb->ioVRefNum= dp->volrefnum;
	fpb->ioFDirIndex= dp->nextfile++;
	fpb->ioFVersNum= 0;
	err= PBGetCatInfo(&cipbr, FALSE);
	if (err != noErr) {
		errno = EIO;
		return NULL;
	}
	p2cstr((StringPtr)dir.d_name);
	dir.d_namlen = strlen(dir.d_name);
	dir.d_reclen = sizeof(dir);
	dir.d_ino = 0;
	return &dir;
}

void rewinddir(DIR *dp)
{
		dp->nextfile = 1;
}

/*
long telldir(DIR *dp)
{
   return dp->nextfile;
}

void seekdir(DIR *dp, long location)
{
  dp->nextfile = location;
}
*/