#!/bin/csh

rm -f smakefile Makefile maketemp
touch smakefile Makefile maketemp

set inc = ( *.h )
set src = ( `ls -1 *.c | grep -v testxephem` )
set obj
foreach f ( $src )
  set obj = ( $obj ${f:r}.o )
end

echo '' >> maketemp
echo 'all: libxastro.a' >> maketemp
echo '' >> maketemp
echo 'clean:' >> maketemp
echo '	rm -f libxastro.a *.o testxephem' >> maketemp
echo '' >> maketemp
echo 'OBJASTRO = '${obj} >> maketemp
echo '' >> maketemp
echo 'libxastro.a : $(OBJASTRO)' >> maketemp
echo '	$(AR) $(ARFLAGS) $@ $?' >> maketemp
echo '' >> maketemp

foreach f ( $obj )
  set c = ${f:r}.c
  echo "${f}: ${c} ${inc}" >> maketemp
  echo '	$(CCOMPILE) -o $@' $c >> maketemp
  echo '' >> maketemp
end

echo 'testxephem: testxephem.o' >> maketemp
echo '	$(CLINK) -o $@ testxephem.o -L./ -lxastro -lc -lm' >> maketemp
echo '' >> maketemp
echo "testxephem.o: testxephem.c astro.h" >> maketemp
echo '	$(CCOMPILE) -o $@ testxephem.c'  >> maketemp
echo '' >> maketemp

echo 'include $(SOPHYABASE)/include/sophyamake.inc' >> smakefile
cat maketemp >> smakefile

echo 'include ../BuildMgr/sophyamake.inc' >> Makefile
cat maketemp >> Makefile

rm -f maketemp

exit 0
