#include <stdlib.h>
#include <stdio.h>

/*  Ceci est un programme test des differents composants de PI : PEIDA Interactif */
/*                 Reza ,  96-98                                                  */

/*   C'est ecrit n'importe comment !     */
 
#include "sopnamsp.h"
#include "pisysdep.h"

#include PIAPP_H
#include PIWIN_H 
#include PIMENU_H 
#include PIOPTMENU_H 
#include PISTDWDG_H 
#include PIBWDG_H 
#include PIPIXMAP_H 
#include PIFILECHO_H 
#include PILIST_H

#include "piscdrawwdg.h"
#include "piyfxdrw.h"

/*
int SysBeep(int n)
{
for(int i=0; i<n; i++)  putchar('\007');
return(0);
}
*/

class PITestApp : public PIApplication {
public:
	PITestApp(int sx, int sy);
	~PITestApp();

	virtual void	Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

    PIMenu  *m[5];
    PIMenu  *mc[2];
    PICheckBox * ckb;
    PIText * text;
    PIButton * bouton;
    PIButton * bouton2, * bouton3, * bouton4, * bouton5;
    PIButton * bouton11, * bouton12, * bouton13,* bouton14 ,* bouton15 ;
    PILabel * label;
    PIScale * scl;
    PIMenu  * menu;
    PIOptMenu * opt, * opt2;
    bool stnewmen[2];

};



PITestApp::PITestApp(int sx, int sy)
: PIApplication(550, 350)
{
char ans[128];
   m[0] = new PIMenu(Menubar(),"File");
   m[0]->AppendItem("Open", 10101);
   m[0]->AppendItem("Close", 10102);
   m[0]->AppendItem("New", 10103);
//   m[0]->AppendItem("ScBar", 10105);
   m[0]->AppendItem("Quit", 10104);

   m[1] = new PIMenu(Menubar(),"Edit");
   m[1]->AppendItem("Copier", 10201);
   m[1]->AppendItem("Coller", 10202);
   m[1]->AppendItem("Couper", 10203);
   m[1]->AppendCheckItem("Check It", 10205);
   mc[0] = new PIMenu(m[1], "Cascade");
   mc[0]->AppendItem("EdeCas-1", 10221);
   mc[0]->AppendItem("EdeCas-2", 10222);
   mc[0]->AppendItem("EdeCas-3", 10223);
   m[1]->AppendPDMenu(mc[0]);

   m[2] = new PIMenu(Menubar(),"Operation");
   m[2]->AppendItem("AddItem", 10301);
   m[2]->AppendItem("DelItemName", 10302);
   m[2]->AppendItem("DelItemMsg", 10303);

   m[3] = new PIMenu(Menubar(),"Special");
   m[3]->AppendItem("Spec-Opt1", 10401);
   m[3]->AppendItem("Spec-Opt2", 10402);
   m[3]->AppendItem("Spec-Cascade", 10403);
   mc[1] = new PIMenu(m[3], "Spec-Cascade");
   mc[1]->AppendItem("Spec-Cas-1", 10441);
   mc[1]->AppendItem("Spec-Cas-2", 10442);
   mc[1]->AppendItem("Spec-Cas-3", 10443);
   m[3]->AppendPDMenu(mc[1]);
   m[3]->AppendCheckItem("Checkable", 10414);

   m[4] = new PIMenu(Menubar(),"AddMenu2");
   m[4]->AppendItem("option-A", 10501);
   m[4]->AppendItem("option-B", 10502);
   m[4]->AppendItem("option-C", 10503);

   AppendMenu(m[0]);
   AppendMenu(m[1]);   
   AppendMenu(m[2]);

  ckb = new PICheckBox(this->MainWin(), "CheckBox", 166, 60, 20, 10, 10);
  text = new PIText(this->MainWin(), "TEXTE", 180, 30, 20,40);
  text->SetMsg(7440);
  label  = new PILabel(this->MainWin(), "Label", 180, 20, 20,80);
  label->SetBorderWidth(1);
  bouton = new PIButton(this->MainWin(), "->Menu", 33, 60, 25, 20, 120);
  bouton2 = new PIButton(this->MainWin(), "Dialog", 333, 60, 25, 100, 120);
  bouton3 = new PIButton(this->MainWin(), "ScDraw", 433, 60, 25, 180, 120);
  bouton4 = new PIButton(this->MainWin(), "Pixmap", 133, 60, 25, 260, 120);
  bouton5 = new PIButton(this->MainWin(), "List", 533, 60, 25, 340, 120);

  scl = new PIScale(this->MainWin(), "Scale", 88, kSDirRtoL, 200, 20, 10, 150);
  scl->SetMinMax(5, 45);

  int psx, psy;
  PrefCompSz(psx, psy);
  cout << " Creation bouton 11 -14 avec Sx,Sy= " << psx << " , " << psy << endl;

  bouton11 = new PIButton(this->MainWin(), "AddMen-1", 1133, psx*1.5, psy, 20, 250);
  bouton12 = new PIButton(this->MainWin(), "AddMen-2", 1233, psx*1.5, psy, 40+psx*1.5, 250);
  stnewmen[0] = stnewmen[1] = false;
  bouton13 = new PIButton(this->MainWin(), "Ready/Bloc", 1333, psx*1.5, psy, 20, 300);
  bouton14 = new PIButton(this->MainWin(), "TS-BWdg", 1433, psx*1.5, psy, 40+psx*1.5, 300);
  bouton15 = new PIButton(this->MainWin(), "TS-MenuIt", 1533, psx*1.5, psy, 60+psx*3, 300);

//  XSync(PIXDisplay(), FALSE);
//  printf("Creation PIPUMenu DoIt-1... \n");   gets(ans);
  menu = new PIMenu(this->MainWin(), "myMenu");
//  XSync(PIXDisplay(), FALSE);
//  printf("Apres Creation PIPUMenu -AppendItem() 1 ... \n");   gets(ans);

  menu->AppendItem("DoIt-1", 4401);
//  XSync(PIXDisplay(), FALSE);
//  printf("Apres Creation PIPUMenu -AppendItem() 2 ... \n");   gets(ans);

  menu->AppendItem("DoIt-2", 4402);
  menu->AppendItem("DoIt-25", 4425);
  menu->AppendItem("DoIt-26", 4426);
  menu->AppendItem("Check-33", 4433);

//  XSync(PIXDisplay(), FALSE);
//  printf("Creation PIPUMenu Copier ... \n");   gets(ans);


  opt = new PIOptMenu(this->MainWin(), "Option-Menu-1", 120, 25, 10, 200);
  opt->AppendItem("Linear", 5601);
  opt->AppendItem("Log.", 5602);
  opt->AppendItem("Sqrt", 5603);
  opt->AppendItem("Expon", 5604);
  opt->AppendItem("Polyn", 5605);

  string ops = "Sqrt";
  opt->SetValueStr(ops);

  opt2 = new PIOptMenu(this->MainWin(), "Option-Menu-1", 120, 25, 150, 200);
  opt2->AppendItem("Copier", 80201);
  opt2->AppendItem("Coller", 80202);
  opt2->AppendItem("Couper", 80203);
  opt2->AppendItem("Undo", 80204);
  opt2->AppendItem("Select-All", 80205);
  
}

PITestApp::~PITestApp()
{
  delete ckb;
  delete text;
  delete label;
  delete bouton;
  delete bouton2;
  delete bouton3;
  delete bouton4;
  delete bouton5;
  delete bouton11;
  delete bouton12;
  delete bouton13;
  delete bouton14;
  delete bouton15;
  delete menu;
  delete m[0]; delete m[1]; delete m[2]; delete m[3]; delete m[4];
  delete mc[0]; delete mc[1];
  delete opt;
  delete opt2;
  delete scl;
}

/* ........................................................... */
/*                         Classe ScSample                     */
/* ........................................................... */

class ScSample : public PIScDrawWdg {
public:
  ScSample(PIContainerGen *par, char *nom,
           int sx=10, int sy=10, int px=0, int py=0);
  virtual ~ScSample();
};

static double fpol(double x) {return (0.3*x*x*x-x*x+7.);}
static double fx2(double x) {return (0.5*x*x);}

ScSample::ScSample(PIContainerGen *par, char *nom,
                  int sx, int sy, int px, int py)
:PIScDrawWdg(par, nom, sx, sy, px, py)

{
// Definition des limites
SetLimits(-3,5,-10,15);

// Creation et ajout d'un drawer de fonctions
PIFuncDrawer* mfd = new PIFuncDrawer(fpol);
mfd->GetGraphicAtt().SetColAtt(PI_Blue);
mfd->GetGraphicAtt().SetLineAtt(PI_NormalLine);
AddScDrawer(mfd,true);
PIFuncDrawer* mfd2 = new PIFuncDrawer(fx2);
mfd2->GetGraphicAtt().SetColAtt(PI_Red);
mfd2->GetGraphicAtt().SetLineAtt(PI_NormalLine);
AddScDrawer(mfd2,true);
SetAxesFlags(kAxesDflt);
}

ScSample::~ScSample()
{
}

static ScSample *scs1, *scs2, *scs3;
static PIScrollBar *scb, *scb2;

static PIWindow * wp3, *wp4, *wp5, *wp6;
static PIPixmap * pxm;
static unsigned char  pixels[25000];
static PIFileChooser *pfc;
static bool  fgpxm = false;
static bool  fgt = false;
static bool  fgt2 = false;
static bool  fgt3 = false;

static PIListX * pil;

void
PITestApp::Process(PIMessage msg, PIMsgHandler* sender, void* data)
{
  static int x = 0;
  static PIMessage numsg=8800;

  char truc[256];
  sprintf(truc,"< %ld - %d (%d)>",msg,x++, (int)((PIWdgGen *)sender)->kind());
  this->label->SetLabel(truc);
  sprintf(truc,"[%d] Msg= %ld (%d-%d) Kind=(%d)  Data= (%ld - %lx)",x, msg, (int)UserMsg(msg),
         (int)ModMsg(msg), (int)((PIWdgGen *)sender)->kind(), (long)data, (long)data);
  puts(truc);

  if (ModMsg(msg) == PIMsg_Active) 
     printf("Process: Setting active Wdg (%lx) \n", (long)sender); 

  if (ModMsg(msg) == PIMsg_Close)
    {
    printf("Close Message received (Sender= %lx)\n", (long)sender);
    return;
    }

  msg = UserMsg(msg);
  if (msg == 33) { ckb->SetState(true);  menu->Show(); }
    
  if (msg == 133)
    {
    if (!fgpxm)  { wp3->Show();  fgpxm = true; }
    for (int i=0; i<25000; i++)  pixels[i] = rand()%256;
    if ((x % 3) == 0)  pxm->SetColMapId(CMAP_GREY32);
    if ((x % 3) == 1)  pxm->SetColMapId(CMAP_COLRJ32);
    if ((x % 3) == 2)  pxm->SetColMapId(CMAP_COLBR32);
    }

  if (msg == 333)  wp4->Show();
  if ( (msg == 6001) || (msg == 6002) )  wp4->Hide();

  if (msg == 433)
    {
    if (fgt2) { wp5->Hide();   fgt2 = false; }
    else { wp5->Show();   fgt2 = true; }
    }

  if (msg == 533)
    {
    if (fgt3) { wp6->Hide(); fgt3 = false; }
    else { wp6->Show(); fgt3 = true; }
    }

  if ( (msg == 1133) || (msg == 1233) )  {  // On ajoute ou on enleve un  menu du menu-bar
    int idxmen = (msg-1133)/100;
    cout << " Add/Remove Menu idxmen= " << idxmen << " Bool= " 
         << Menubar()->IsSensitive(m[idxmen+3])  << " ( " << stnewmen[idxmen] << ")" << endl;
    if ( Menubar()->IsSensitive(m[idxmen+3]) ) 
      { Menubar()->RemoveMenu(m[idxmen+3]); stnewmen[idxmen] = false; }
    else  { Menubar()->AppendMenu(m[idxmen+3]); stnewmen[idxmen] = true; }
  }

  if (msg == 1333) {  // Changement de sensibilite de Menu-Bar (par SetBusy())
    cout << " SetSens() Menubar,  State= " <<  GetState()  << endl;
    if (GetState() != kReadyState)  SetReady();
    else  SetBlocked();
  }

  if (msg == 1533) {  // Changement de sensibilite de  Cascade
    cout << " ChangeSensitivity()  Cascade Bool= " <<  m[1]->IsSensitive("Cascade")  << endl;
    if (m[1]->IsSensitive("Cascade") )  m[1]->SetSensitivity("Cascade", false); 
    else  m[1]->SetSensitivity("Cascade", true); 
  }

  if (msg == 1433) {  // Changement de sensibilite de  BaseWidget (ScSample)
    if (scs1->IfSensitive())  scs1->SetUnSensitive();
    else scs1->SetSensitive();
  }
//  if (msg == 555)   (this->menu)->Show(); 

  if (msg == 10105)  scb->SetSlSize(atoi(((char *)text->GetText().c_str())));
  if (msg == 10104)  Stop();
  if (msg == 10101)  { pfc->AcceptNewFile(false); pfc->Show(); }
  if (msg == 10103)  { pfc->AcceptNewFile(true); pfc->Show(); }

  if ((msg == 10205) || (msg == 166))  { // CheckItem Menu  or checkbox
    cout << "PITestApp::Process CheckItem/Box Menu (" << msg 
         << ") State=" <<  *((bool *)data) << endl; 
  }

  if (msg == 10301)  
   { 
   numsg++;    
   string nit;
   nit = text->GetText();
   m[1]->AppendItem((char *)nit.c_str(), numsg); 
   opt2->SetValue(numsg);
   }

  if (msg == 10302)  { m[1]->DeleteItem((char *)text->GetText().c_str()); }
  if (msg == 10303)  
    {
    string nit;
    nit = text->GetText();
    long ml =  atol(nit.c_str());
    m[1]->DeleteItemMsg(ml);
    opt2->SetValue(10201);
    }


  if (msg > 9000) printf("PITestApp::MenubarReturn: %d --> %lx \n", msg, (long)data);
  if (msg == 5000)  
    { 
    if (data) 
      { 
      printf("PITestApp::Process(5000) OK from PIFileChooser: %s \n", (char *)data); 
    }
    else printf("PITestApp::Process(5000) Cancel from PIFileChooser (data=NULL) \n");  }

  if ((msg / 100) == 56) 
    printf("PITestApp::Process(%d) : %lx \n", (int)msg, (long)data); 

  if (msg == 8811) printf("PITestApp::Process(8811) ScrollBar( %d ) \n", *( (int*)data) );
  else if (msg == 8821) printf("PITestApp::Process(8821) ScrollBar( %d ) \n", *( (int*)data) );

}

int main(int narg, char *arg[])
{
  int mii;

  if (narg < 2) {
    printf("Usage pitst str1 [str2 ....] \n");  exit(1); 
  }

  PITestApp * app;
  app = new PITestApp(350, 350);


  wp4 = new PIWindow(app, "Window-4", PIWK_dialog,  200, 200, 350, 350);
  PIButton bt1(wp4, "OK", 6001, 60, 30, 20, 160);
  PIButton bt2(wp4, "Cancel", 6002, 60, 30, 100, 160);
  bt1.SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic,PIBK_elastic);
  bt2.SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic,PIBK_elastic);
  PILabel  lb1(wp4, "Editable", 40, 30, 10, 10);
    lb1.SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic,PIBK_elastic);
  PIText  tx1(wp4, "A00", 100, 30, 60, 10);  
    tx1.SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic,PIBK_elastic);
  tx1.SetText("Hello");
  tx1.SetTextEditable(false);
  //  PILabel  lb2(wp4, "", 30, 20, 10, 40);
  PIText  tx2(wp4, "A11", 180, 100, 15, 50);
  tx2.SetMutiLineMode(true);
  tx2.SetText(" Bonjour, \n Comment ca va ? \n A demain. ");
    tx2.SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic,PIBK_elastic);

  wp3 = new PIWindow(app, "Window-3", PIWK_normal, 200, 200, 350, 350);
  pxm = new PIPixmap(wp3, "myPixmap", 150, 150, 10, 10);
  pxm->SetBinding(PIBK_fixed,PIBK_fixed,PIBK_fixed,PIBK_fixed );
  pxm->SetPixmap(pixels, 150, 150);

  wp5 = new PIWindow(app, "Window-5", PIWK_normal,  420, 450, 200, 200);
  scs1 = new ScSample(wp5, "ScSample", 200, 200, 0, 0);
  scs1->SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic,PIBK_elastic);
  scs2 = new ScSample(wp5, "ScSample", 160, 160, 220, 20);
  printf("DBG-WP5 (A) , SCS2, SzC %d %d , Sz %d %d Pos %d %d \n", wp5->XSize(),
         wp5->YSize(), scs2->XSize(), scs2->YSize(),scs2->XPos(), scs2->YPos() ); 
//  scs2->SetBinding(PIBK_elastic,PIBK_fixed,PIBK_fixed,PIBK_elastic);
  scs2->SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic,PIBK_elastic);
  printf("DBG-WP5 (B) , SCS2, SzC %d %d , Sz %d %d Pos %d %d \n", wp5->XSize(),
         wp5->YSize(), scs2->XSize(), scs2->YSize(),scs2->XPos(), scs2->YPos() ); 

  scb = new PIScrollBar(wp5, "ScBar", 8811, kSDirUpDown, 15, 420, 405, 0);
  scb->SetBinding(PIBK_free,PIBK_fixed,PIBK_fixed,PIBK_fixed);
  scb->ActivateDrag(true);
  scb2 = new PIScrollBar(wp5, "ScBar", 8821, kSDirRtoL, 420, 15, 0, 425);
  scb2->SetBinding(PIBK_fixed,PIBK_free,PIBK_fixed,PIBK_fixed);

  scs3 = new ScSample(wp5, "ScSample", 200, 200, 100, 220);
  scs3->SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic,PIBK_elastic);

  pfc = new PIFileChooser(app,"FileChooser", 5000); 
//  pfc->SetPath("/exp/eros/ImagRed/");

  wp6 = new PIWindow(app, "Window-List", PIWK_normal,  200, 250, 300, 400);
  pil = new PIListX(wp6, "MyList", 200, 250, 0, 0);
  pil->SetBinding(PIBK_fixed,PIBK_fixed,PIBK_fixed,PIBK_fixed);
  for(mii=1; mii<narg; mii++)
    {
//    printf("AppendItem[%d] - %s (%ld) \n", mii, arg[mii],  3330+mii);  
     pil->AppendItem(arg[mii], 3330+mii);  
//    puts("Append-OK");
    }
  pil->SetMultipleSelect(true);
  pil->SelectItem("user.cc");
//  Int32 ioNumber = 100;
  app->Run();
  delete app;
  exit(0);
}
