// Module PI : Peida Interactive     PIBaseWdg
// Classe de base pour nouvelles composantes graphiques  96
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdio.h>

#include "sopnamsp.h"
#include "pibwdggen.h"
#include "pidrawer.h"
#include "pigraphps.h"
#include "pidrwtools.h"

static inline void dbl_swap(double& a, double& b) { double tmp = a; a = b; b = tmp;  } 

//++
// Class	PIBaseWdg
// Lib		PI
// include	pibwdggen.h
//
//   	Classe de base pour la cration de nouvelles composantes graphiques.
//	Le traitement des vnements lis  l'cran, clavier, souris se fait
//	 travers des mthodes de cette classe : "Resize()", "But1Press()", ...
//	La classe "PIBaseWdg" supporte en outre un mcanisme permettant
//	d'associer un ou plusieurs objets traceur (*Drawer*) capables 
//	de se dessiner dans la fentre associe  l'objet.
//	La classe "PIBaseWdgGen" dfinit l'interface et ne peut pas tre instancie 
//	directement (Mthodes virtuelles pures). Les objets instancis sont de la 
//	classe "PIBaseWdg" et le fichier entte correspondant est "PIBWDG_H"
//	dfini dans "pisysdep.h".
//--
//++
// Links	Parents
// PIWdg
//--
//++
// Links	Voir aussi
// PIGraphic
// PIDrawer
//--

// ---------- Les methodes de la classe  PIBWdgGen ------------

//++
// Titre	Constructeur
//--
//++
//  PIBaseWdgGen(PIContainerGen *par, const char *nom, int sx=10, int sy=10, int px=0, int py=0)
//	Cration d'un objet contenu dans l'objet *PIContainer* "par", de
//	taille "sx,sy", se trouvant  la position "px,py" avec le nom "nom"	
//--

//++
// Titre	Mthodes
//--
//++
// void  SelPointerShape(PIPointer ptr=PI_ArrowPointer) 
//	Choix de la forme du pointeur (souris) pour la fentre 
//	associe  l'objet.
//|	PI_ArrowPointer, PI_CrossPointer, PI_HandPointer, PI_TDLRArrowPointer
// PIPointer  GetPointerShape() 
//	Renvoie la forme du pointeur
//--

//++
// Titre	Activation du traitement des vnements
//--
//++
// void  ActivatePtrCross()
//	Active l'appel aux mthodes "Enter()" et "Leave()" lorsque la souris
//	rentre ou sort de la fentre correspondante  l'objet
// void  ActivateButton(int b)
//	Active l'appel aux mthodes "ButbPress()" et "ButxRelease()" pour
//	le bouton "b" de la souris ("b=1,2,3")
// void  ActivateMove(int b) 
//	Active l'appel aux mthodes "PtrbMove()" lors des mouvements de
//	la souris avec le bouton "b" enfonc ("b=1,2,3")
//	L'appel avec "bid=0" active l'appel  la mthode "PtrMove()"
//	Lors des mouvements de souris sans bouton enfonc.
// void  ActivateKeyboard()
//	Active l'appel  la mthode "Keyboard()" lors de l'appui sur les 
//	touches du clavier.
//--

 
/* --Methode-- */
PIBaseWdgGen::PIBaseWdgGen(PIContainerGen *par, const char *nom,
                       int sx, int sy, int px, int py) :
PIWdg(par, nom, sx, sy, px, py)
{
mDrwId=0;   // Compteur des numeros sequentiel des PIDrawer
mActDrwId = -1;  // Identificateur du drawer actif
mAdfg=false;    // Pour controle d'appel de RemoveDrawer()
mWGrC = NULL;   // PIGraphic (Contexte graphique) associe a la fenetre}
                // Doit etre cree par PIBaseWdgX/Mac/... 
SetDefaultDrawRectangle(0., 0., 1., 1., true);
SetDefaultDrawerLimits(0., 1., 0., 1., kAxeDirLtoR, kAxeDirUpDown);
SetDefaultDrawerLogScale(false, false);
}

/* --Methode-- */
PIBaseWdgGen::~PIBaseWdgGen()
{
delete mWGrC;
if (PIDrwTools::GetCurrentBaseWdg() == this) 
  PIDrwTools::SetCurrentBaseWdg(NULL);
DeleteDrawers();
}
 

/* --Methode-- 
void PIBaseWdgGen::Refresh()
{
if ( IsVisible() )  { 
  Draw(mWGrC, 0, 0, XSize(), YSize());
  CallDrawers(mWGrC); 
}
return;
}
*/

//++
// Titre	Gestion des vnements
//--
//++
// void  Draw(PIGraphic* g, int x0, int y0, int dx, int dy)
//	Mthode appele lorsqu'il faut redessiner tout ou partie de
//	la fentre. La zone a rafrachir est determine par 
//	"(x0,y0)", "dx,dy" et "g" est l'objet "PIGraphic" 
//	qui doit tre utilis.
//	Cette mthode ne doit pas tre appel directement. 
//	Pour rafrachir le contenu de la fentre, il faut appeler
//	la mthode "Refresh()"
// void  Resize()
//	Mthode appele lorsque la taille de l'objet est modifie.
//	"XSize()", "YSize()" fournissent la nouvelle taille de l'objet.
// void  Enter()
//	Mthode appele lorsque le pointeur rentre dans la fentre
//	(Si "ActivatePtrCross()" a t appel )
// void  Leave()
//	Mthode appele lorsque le pointeur quitte la fentre
//	(Si "ActivatePtrCross()" a t appel )
// void  ButbPress(int x, int y)  (b=1,2,3)
//	Mthode appele lorsque le bouton "b=1,2,3" de la souris est enfonc.
//	"x,y" : Position de la souris
//	(Si "ActivateButton(b)" a t appel )
// void  ButbRelease(int x, int y)   (b=1,2,3)
//	Mthode appele lorsque le bouton "b=1,2,3" de la souris est relach.
//	"x,y" : Position de la souris
//	(Si "ActivateButton(b)" a t appel )
// void  PtrMove(int x, int y)
//	Mthode appele lors des mouvements de la souris. "x,y" : Position de la souris
//	(Si "ActivateMove(0)" a t appel )
// void  PtrbMove(int x, int y)     (b=1,2,3)
//	Mthode appele lors des mouvements de la souris, avec le 
//	bouton "b=1,2,3" appuy. "x,y" : Position de la souris
//	(Si "ActivateMove(b)" a t appel )
// void  Keyboard(int key, PIKeyModifier kmod)
//	Mthode appele en rponse  des actions sur le clavier.
//	"key" est le code ASCII de la touche enfonc - "kmod" indique
//	si des touches speciaux taient enfoncs en mme temps.
//|	kmod =  PIKM_Blank |  PIKM_Shift | PIKM_Alt | PIKM_Cntl
//	Des constantes ont t dfinis pour certaines touches particulires
//|	PIK_Return , PIK_Enter , PIK_BackSpace, PIK_Delete
//|	PIK_Tab , PIK_Escape , PIK_Up , PIK_Down, 
//|	PIK_Right , PIK_Left , PIK_Previous , PIK_Next
//--

/* --Methode-- */
void PIBaseWdgGen::Draw(PIGraphic* g, int x0, int y0, int dx, int dy)
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Draw() Efface la fenetre par defaut ! ");
#endif
if (g->kind() != PI_PSFileGraphics) EraseWindow(x0, y0, dx, dy);
return;
}

/* --Methode-- */
void PIBaseWdgGen::Resize()
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Resize()  resize notify ");
#endif
return;
}


/* --Methode-- */
void PIBaseWdgGen::Enter()
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Enter() enter notify ");
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::Leave()
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Leave() leave notify ");
#endif
return;
}


/* --Methode-- */
void PIBaseWdgGen::But1Press(int /*x*/, int /*y*/)
{
Send(Msg(), PIMsg_Active);
#ifdef DEBUG_RZXB
printf ("PIBaseWdgGen::But1Press PosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::But1Release(int /*x*/, int /*y*/)
{
#ifdef DEBUG_RZXB
printf ("PIBaseWdgGen::ButReleasePosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::But2Press(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::But2Release(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::But3Press(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::But3Release(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::PtrMove(int /*x*/, int /*y*/)
{
#ifdef DEBUG_RZXB
printf ("Debug_PIBaseWdgGen::PtrMove PosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::Ptr1Move(int /*x*/, int /*y*/)
{
#ifdef DEBUG_RZXB
printf ("Debug_PIBaseWdgGen::Ptr1Move PosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::Ptr2Move(int /*x*/, int /*y*/)
{
return;
}


/* --Methode-- */
void PIBaseWdgGen::Ptr3Move(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::Keyboard(int /*key*/, PIKeyModifier /*kmod*/)
{
#ifdef DEBUG_RZXB
printf("PIBaseWdgGen::Keyboard: Key= %d (%c)  Mod= %d \n", key, (char)key, (int)kmod); 
#endif
return;
}


/* --Methode-- */
void PIBaseWdgGen::PSPrint(PSFile * psf, int ofx, int ofy, double scale_x, double scale_y)
{
if (!psf) return;
PIGraphicPS grpsf(psf, (PIWdg *)this, ofx, ofy, scale_x, scale_y);
Draw(&grpsf, 0, 0, XSize(), YSize());
CallDrawers(&grpsf); 
return;
}

//++
// Titre	Gestion des traceurs (PIDrawer)
//	Un mme "PIDrawer" peut tre attach simultanement  plusieurs "PIBaseWdg", ainsi
//	que plusieurs fois au mme "PIBaseWdg", avec des identificateurs diffrents.
//	Un des traceurs, par dfaur le dernier ajout est considr comme le traceur 
//	actif ou slectionn (voir "SetActiveDrawer" ...).
//--
//++
// void  SetDefaultDrawRectangle(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, bool elastic=true)
//	Dfinition du rectangle d'attachement par dfaut. "(x1,y1)" et "(x2,y2)" determinent
//	les positions des deux coins opposs.
//	si "elastic=true", les coordonnes sont supposes tre des facteurs multiplicatifs 
//	des dimensions de l'objet.
// void  GetDefaultDrawRectangle(PIGrCoord& x1, PIGrCoord& y1, PIGrCoord& x2, PIGrCoord& y2, bool& elastic)
//	Retourne le rectangle d'attachement par dfaut. "(x1,y1)" et "(x2,y2)" determinent
//	les positions des deux coins opposs."elastic=true": Pos/Taille spcifies en fraction 
//	de la taille du PIBaseWdg.
// void  SetDefaultDrawerLimits(double xmin, double xmax, double ymin, double ymax, -
//                              int axrl=kAxeDirSame, int ayud=kAxeDirSame)
//	Dfinition du systme de coordonnes par dfaut d'un drawer attach 
//	en "autolim=true"
// void  SetDefaultDrawerLogScale(bool logx, bool logy)
//	Dfinition d'chelle logarithmique pour le systme de coordonnes par dfaut
//	d'un drawer attach en "autolim=true".
//
//--

/* --Methode-- */
void PIBaseWdgGen::SetDefaultDrawRectangle(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, bool elastic)
{
mDrX1 = x1;  mDrY1 = y1;
mDrX2 = x2;  mDrY2 = y2;   mDrElastic = elastic;
}

/* --Methode-- */
void PIBaseWdgGen::GetDefaultDrawRectangle(PIGrCoord& x1, PIGrCoord& y1, PIGrCoord& x2, PIGrCoord& y2, bool& elastic)
{
x1 = mDrX1;  y1 = mDrY1;
x2 = mDrX2;  y2 = mDrY2;   elastic = mDrElastic;
}

/* --Methode-- */
void PIBaseWdgGen::SetDefaultDrawerLimits(double xmin, double xmax, double ymin, double ymax,
                                          int axrl, int ayud)
{
mDrXmin = xmin;   mDrXmax = xmax; 
mDrYmin = ymin;   mDrYmax = ymax; 
if (axrl != kAxeDirSame)   mDXdir = axrl;    
if (ayud != kAxeDirSame)   mDYdir = ayud;
}

/* --Methode-- */
void PIBaseWdgGen::SetDefaultDrawerLogScale(bool logx, bool logy)
{
mDXlog = logx; 
mDYlog = logy; 
}

//++
// int  AddDrawer(PIDrawer* drw, PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, -
//                bool psz=true, bool clip=true, bool ad=false, bool lock=false)
//	Attachement d'un "PIDrawer" au rectangle dfini les coordonnes des deux coins opposs.
//	si "psz=true", les coordonnes sont supposes tre des facteurs multiplicatifs 
//	des dimensions de l'objet.
//	si "clip=true", "PIDrawer* drw" ne peut dessiner en dehors de son rectangle
//	d'attachement.
//	si "ad=true", le "PIDrawer* drw" est dtruit lors de la destruction de l'objet PIBaseWdg.
//	si "lock=true", le drawer ne peut tre dtach suite  une requte interactive.
//	La mthode retourne l'identificateur du drawer attach.
// int  AddDrawer(PIDrawer* drw, bool autolim=false, bool clip=true, bool ad=false, bool lock=false)
//	Ajout d'un "PIDrawer" au rectangle d'attachement par dfaut. 
//	Si "autolim=true", l'objet "PIBaseWdg" impose l'espace de coordonnes utilisateur
//	 l'aide des valeurs dfinies par "SetDefaultDrawerLimits()".
//	Si ""clip=true", "PIDrawer* drw" ne peut dessiner en dehors de son rectangle 
//	d'attachement.
//	si "ad=true", le "PIDrawer* drw" est dtruit lors de la destruction de l'objet PIBaseWdg.
//	si "lock=true", le drawer ne peut tre dtach suite  une requte interactive.
//	La mthode retourne l'identificateur du drawer attach.
//--

/* --Methode-- */
int PIBaseWdgGen::AddDrawer(PIDrawer* drw, PIGrCoord x1, PIGrCoord y1,  
                            PIGrCoord x2, PIGrCoord y2, bool psz, bool clip, bool ad, bool lock)
{
if (drw == NULL)   return(0);
mDrwId++;
BWDrwId did;
did.x1 = x1;  did.y1 = y1;
did.x2 = x2;  did.y2 = y2;
did.autoszp = did.autolim = false;   
did.elastic = psz;  did.clip = clip;
did.id = mDrwId;  did.ad = ad; 
did.lock = lock;
did.drw = drw;
mDrwList.push_back(did);
drw->Attach(this, mDrwId);
mActDrwId = mDrwId;   // Le dernier drawer ajoute devient le drawer actif par defaut
return(mDrwId);
}

/* --Methode-- */
int PIBaseWdgGen::AddDrawer(PIDrawer* drw, bool autolim, bool clip, bool ad, bool lock)
{
if (drw == NULL)   return(0);
mDrwId++;
BWDrwId did;
did.x1 = 0.;  did.y1 = 0.;
did.x2 = 1.;  did.y2 = 1.;
did.autoszp = true;   did.autolim = autolim;   
did.elastic = false;   did.clip = clip;
did.id = mDrwId;  did.ad = ad;
did.lock = lock; 
did.drw = drw;
mDrwList.push_back(did);
drw->Attach(this, mDrwId);
mActDrwId = mDrwId;   // Le dernier drawer ajoute devient le drawer actif par defaut
return(mDrwId);
}


//++
// void  MoveResizeDrawer(int id, PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, bool elastic=true)
//	Modification du rectangle d'attachement du PIDrawer avec l'identificateur "id" , retourn
//	par "AddDrawer()". Si "elatic=true", taille/pos spcifie en fraction de la taille du PIBaseWdg.
// void  RemoveDrawer(int id)
//	Ote le drawer "id" de la liste des drawers du PIBaseWdg.
// void  DeleteDrawers()
//	Ote tous les drawers de la liste. Dtruit ceux ajouts avec l'option "ad=true" 
//--

/* --Methode-- */
void PIBaseWdgGen::MoveResizeDrawer(int id,  PIGrCoord x1, PIGrCoord y1,  PIGrCoord x2, PIGrCoord y2, bool elastic)
{
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).id == id) { 
    (*it).x1 = x1;  (*it).y1 = y1;
    (*it).x2 = x2;  (*it).y2 = y2;
    (*it).elastic = elastic;
    break;
  }
return;
}

/* --Methode-- */
void PIBaseWdgGen::RemoveDrawer(int id)
{
if (mAdfg)  return;
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)
  if ((*it).id == id) {
    (*it).drw->Detach(this, id); mDrwList.erase(it); 
    if (id == mActDrwId) {
      if (NbDrawers() > 0) mActDrwId = (*(mDrwList.end()-1)).id;
      else mActDrwId = -1;
    }
    
  break; 
  }
return;
}

/* --Methode-- */
void PIBaseWdgGen::DeleteDrawers()
{
mAdfg = true;
mActDrwId = -1;
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).ad)  delete (*it).drw;
mDrwList.erase(mDrwList.begin(), mDrwList.end() );
mAdfg = false;
return;
}

//++
// int  NbDrawers()
//	Retourne le nombre de PIDrawer attachs
// PIDrawer*  GetDrawerId(int id)
//	Retourne le PIDrawer avec l'identificateur "id".
// PIDrawer*  GetDrawer(int n)
//	Retourne le PIDrawer "n=0..NbDrawers()-1" de la liste
// int  GetDrawerIdFromNum(int n)
//	Retourne l'identificateur du drawer numero "n=0..NbDrawers()-1". 
// bool IsDrawerLockedId(int id)
//	Retourne le flag "lock" pour le PIDrawer avec l'identificateur "id".
//	si "true", le drawer ne doit tre dtach suite  une requte interactive.
// bool IsDrawerAutoSizePos(int id)
//	Retourne "true" si le  PIDrawer (Identificateur= "id") est positionn
//	dans le rectangle par dfaut.
// void GetDrawerPosition(int id, PIGrCoord& x1, PIGrCoord& y1, PIGrCoord& x2, PIGrCoord& y2, bool& elastic)
//	Retourne le rectangle d'attachement du PIDrawer avec l'identificateur "id".
//	"elastic=true": position et taille spcifies en fraction de la taille du PIBaseWdg.
//--

/* --Methode-- */
int PIBaseWdgGen::GetDrawerIdFromNum(int n)
{
if ( (n < 0) || (n >= mDrwList.size()) ) return(-1);
return(mDrwList[n].id);
}


/* --Methode-- */
PIDrawer* PIBaseWdgGen::GetDrawer(int n)
{
if ( (n < 0) || (n >= mDrwList.size()) ) return(NULL);
return(mDrwList[n].drw);
}

/* --Methode-- */
PIDrawer* PIBaseWdgGen::GetDrawerId(int id)
{
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).id == id)  return((*it).drw);
return(NULL);
}

/* --Methode-- */
bool PIBaseWdgGen::IsDrawerLockedId(int id)
{
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).id == id)  return((*it).lock);
return true;
}

/* --Methode-- */
bool PIBaseWdgGen::IsDrawerAutoSizePos(int id)
{
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).id == id)  return( (*it).autoszp );
return false;
}

/* --Methode-- */
void PIBaseWdgGen::GetDrawerPosition(int id, PIGrCoord& x1, PIGrCoord& y1, 
				     PIGrCoord& x2, PIGrCoord& y2, bool& elastic)
{
x1 = y1 = x2 = y2 = 0;
elastic = false;
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).id == id) { 
    x1 = (*it).x1;  y1 = (*it).y1;
    x2 = (*it).x2;  y2 = (*it).y2;
    elastic = (*it).elastic;
    break;
  }
return;
}

//++
// void  SetActiveDrawerId(int id)
//	Slectionne le traceur (PIDrawer) avec l'identificateur "id" comme traceur actif.
// void  SetActiveDrawer(int n)
//	Slectionne le traceur numro "n" de la liste comme traceur actif.
// int   GetActiveDrawerId()
//	Retourne l'identificateur du traceur actif (-1 si pas de traceur actif).
// int   GetActiveDrawerNum()
//	Retourne le numro du traceur actif dans la liste (index dans le vecteur de traceurs -
//	-1 si pas de traceur actif).
// PIDrawer*  GetActiveDrawer()
//	Retourne le pointeur sur le traceur actif (NULL si pas de traceur actif).
// int   FindNearestDrawerId(int x, int y)
//	Retourne le numro du traceur le plus proche au point "(x,y)" de l'objet PIBaseWdg. 
//	-1 si pas de traceur.
//--

/* --Methode-- */
void PIBaseWdgGen::SetActiveDrawerId(int id)
{
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).id == id) { mActDrwId = id; break; }
return;
}

/* --Methode-- */
void PIBaseWdgGen::SetActiveDrawer(int n)
{
if ( (n >= 0) && (n < mDrwList.size()) ) mActDrwId = mDrwList[n].id;
return;
}

/* --Methode-- */
int PIBaseWdgGen::GetActiveDrawerId()
{
  return(mActDrwId);
}

/* --Methode-- */
int PIBaseWdgGen::GetActiveDrawerNum()
{
  if (mActDrwId < 0) return(-1);
  for(int i=0; i<mDrwList.size(); i++) 
    if (mDrwList[i].id == mActDrwId) return(i);
  return(-1);
}

/* --Methode-- */
PIDrawer*  PIBaseWdgGen::GetActiveDrawer()
{
  if (mActDrwId < 0) return(NULL); 
  else return(GetDrawerId(mActDrwId));
}

/* --Methode-- */
int PIBaseWdgGen::FindNearestDrawerId(int xp, int yp)
{
  if (mDrwList.size() < 1)  return -1;
  double xmin,ymin, xmax, ymax;
  int drx0, dry0, drdx, drdy;
  int ddrx0, ddry0, ddrdx, ddrdy;

  if (mDrElastic) { 
    ddrx0 = (int)((double) mDrX1 * (double)XSize());
    ddry0 = (int)((double) mDrY1 * (double)YSize());
    ddrdx = (int)((double) mDrX2 * (double)XSize()) - ddrx0 ;
    ddrdy = (int)((double) mDrY2 * (double)YSize()) - ddry0 ;
  }
  else {
    ddrx0 = (int)mDrX1;   ddry0 = (int)mDrY1;  
    ddrdx = (int)mDrX2-ddrx0;   ddrdy = (int)mDrY2-ddry0;  
  }
  
  int nid = -1;
  double neardist = 9.e39;
  bool fgido = false;
  
  vector<BWDrwId>::iterator it;
  for(it = mDrwList.begin(); it != mDrwList.end(); it++) {
    if ( (*it).autoszp )   // Taille/position  par defaut impose par PIBaseWdg 
      { drx0 = ddrx0;  dry0 = ddry0;   drdx = ddrdx;  drdy = ddrdy; } 
    else {
      if ( (*it).elastic  ) {   // Taille/position defin en fraction de la taille du PIBaseWdg
	drx0 = (int)((double)(*it).x1 * (double)XSize());
	dry0 = (int)((double)(*it).y1 * (double)YSize());
	drdx = (int)((double)(*it).x2 * (double)XSize()) - drx0 ;
	drdy = (int)((double)(*it).y2 * (double)YSize()) - dry0 ;
      }
      else {
	drx0 = (int)(*it).x1 ;  dry0 = (int)(*it).y1 ; 
	drdx = (int)(*it).x2-drx0 ;  drdy = (int)(*it).y2-dry0 ; 
      }
    }
    // L'ordre des operations ici est importante 
    if ( (*it).autolim ) {
      (*it).drw->SetLimits(mDrXmin, mDrXmax, mDrYmin, mDrYmax, mDXdir, mDYdir);     
      (*it).drw->SetLogScale(mDXlog, mDYlog);
    }
    double xu, yu;
    (*it).drw->WdgCoord2DrwCoord(xp, yp, xu, yu, drx0, dry0, drdx, drdy);
    double curd = (*it).drw->GetDistanceToPoint(xu, yu);
    if (!fgido || (curd < neardist)) {
      neardist = curd;  nid = (*it).id;  fgido = true;
    }
  }
return nid;  
}

//++
// void  CallDrawers(PIGraphic* g, int x0=0, int y0=0, int dx=0, int dy=0)
//	Appel de la mthode de trac pour tous les Drawers
// void  CallDrawer(int id);
//	Appel de la mthode de trac pour le drawer avec l'identificateur "id"
//--

/* --Methode-- */
void PIBaseWdgGen::CallDrawers(PIGraphic* g, int x0, int y0, int dx, int dy)
{
double xmin,ymin, xmax, ymax;
PIGraphicUC* guc;
int drx0, dry0, drdx, drdy;
int ddrx0, ddry0, ddrdx, ddrdy;

if (mDrElastic) { 
  ddrx0 = (int)((double) mDrX1 * (double)XSize());
  ddry0 = (int)((double) mDrY1 * (double)YSize());
  ddrdx = (int)((double) mDrX2 * (double)XSize()) - ddrx0 ;
  ddrdy = (int)((double) mDrY2 * (double)YSize()) - ddry0 ;
  }
else {
  ddrx0 = (int)mDrX1;   ddry0 = (int)mDrY1;  
  ddrdx = (int)mDrX2-ddrx0;   ddrdy = (int)mDrY2-ddry0;  
  }

bool sxy = false;
if ((dx > 0) && (dy > 0))  sxy = true;

vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++) {
  g->SaveGraphicAtt();
  if ( (*it).autoszp )   // Taille/position  par defaut impose par PIBaseWdg 
    { drx0 = ddrx0;  dry0 = ddry0;   drdx = ddrdx;  drdy = ddrdy; } 
  else {
    if ( (*it).elastic  ) {   // Taille/position defin en fraction de la taille du PIBaseWdg
      drx0 = (int)((double)(*it).x1 * (double)XSize());
      dry0 = (int)((double)(*it).y1 * (double)YSize());
      drdx = (int)((double)(*it).x2 * (double)XSize()) - drx0 ;
      drdy = (int)((double)(*it).y2 * (double)YSize()) - dry0 ;
      }
    else {
      drx0 = (int)(*it).x1 ;  dry0 = (int)(*it).y1 ; 
      drdx = (int)(*it).x2-drx0 ;  drdy = (int)(*it).y2-dry0 ; 
      }
    }
// L'ordre des operations ici est importante 
  if ( (*it).autolim ) {
     (*it).drw->SetLimits(mDrXmin, mDrXmax, mDrYmin, mDrYmax, mDXdir, mDYdir);     
     (*it).drw->SetLogScale(mDXlog, mDYlog);
  }
  guc = (*it).drw->SetDrwWdg(this, drx0, dry0, drdx, drdy, g);
  if ((*it).clip)  g->SetClipRectangle(drx0, dry0, drdx , drdy);  
  (*it).drw->SelGraAtt(guc);
  if (sxy) {
    guc->GrC2UC(x0, y0, xmin, ymin);
    guc->GrC2UC(x0+dx, y0+dy, xmax, ymax);
    }
  else {
    guc->GrC2UC(0, 0, xmin, ymin);
    guc->GrC2UC(XSize(), YSize(), xmax, ymax);    
    } 
  if (xmin > xmax)  dbl_swap(xmin,xmax);
  if (ymin > ymax)  dbl_swap(ymin,ymax);
  (*it).drw->Draw(guc, xmin, ymin, xmax, ymax);
  g->RestoreGraphicAtt();
  if ((*it).clip)  g->ClearClipRectangle();
  }

return;
}

/* --Methode-- */
void PIBaseWdgGen::CallDrawer(int id)
{
double xmin,ymin, xmax, ymax;
PIGraphicUC* guc;
int drx0, dry0, drdx, drdy;
int ddrx0, ddry0, ddrdx, ddrdy;

PIGraphic* g = WindowGraphic();
g->SaveGraphicAtt();

if (mDrElastic) { 
  ddrx0 = (int)((double) mDrX1 * (double)XSize());
  ddry0 = (int)((double) mDrY1 * (double)YSize());
  ddrdx = (int)((double) mDrX2 * (double)XSize()) - ddrx0 ;
  ddrdy = (int)((double) mDrY2 * (double)YSize()) - ddry0 ;
  }
else {
  ddrx0 = (int)mDrX1;   ddry0 = (int)mDrY1;  
  ddrdx = (int)mDrX2-ddrx0;   ddrdy = (int)mDrY2-ddry0;  
  }
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++) 
  if ((*it).id == id) {
    g->SaveGraphicAtt();
    if ( (*it).autoszp )   // Taille/position  par defaut impose par PIBaseWdg 
      { drx0 = ddrx0;  dry0 = ddry0;   drdx = ddrdx;  drdy = ddrdy; } 
    else {
      if ( (*it).elastic  ) {   // Taille/position defin en fraction de la taille du PIBaseWdg
        drx0 = (int)((double)(*it).x1 * (double)XSize());
        dry0 = (int)((double)(*it).y1 * (double)YSize());
        drdx = (int)((double)(*it).x2 * (double)XSize()) - drx0 ;
        drdy = (int)((double)(*it).y2 * (double)YSize()) - dry0 ;
        }
      else {
        drx0 = (int)(*it).x1 ;  dry0 = (int)(*it).y1 ; 
        drdx = (int)(*it).x2-drx0 ;  drdy = (int)(*it).y2-dry0 ; 
        }
      }
// L'ordre des operations ici est importante 
    if ( (*it).autolim ) {
       (*it).drw->SetLimits(mDrXmin, mDrXmax, mDrYmin, mDrYmax, mDXdir, mDYdir);
       (*it).drw->SetLogScale(mDXlog, mDYlog);
    }
    guc = (*it).drw->SetDrwWdg(this, drx0, dry0, drdx, drdy, g);
    if ((*it).clip)  g->SetClipRectangle(drx0, dry0, drdx , drdy);
    (*it).drw->SelGraAtt(guc);
    guc->GrC2UC(0, 0, xmin, ymin);
    guc->GrC2UC(XSize(), YSize(), xmax, ymax);     
    if (xmin > xmax)  dbl_swap(xmin,xmax);
    if (ymin > ymax)  dbl_swap(ymin,ymax);
    (*it).drw->Draw(guc, xmin, ymin, xmax, ymax);
    g->RestoreGraphicAtt();    
    if ((*it).clip)  g->ClearClipRectangle();
    break;
  }
g->RestoreGraphicAtt();
return;
}


/* --Methode-- */
PIGraphic* PIBaseWdgGen::WindowGraphic()
{
return(mWGrC);
}
