// Module PI : Peida Interactive     PIFontMac
// Gestion de fontes - Implementation Mac    
// DAPNIA/SPP     E. Aubourg 1999

#include <stdio.h>

#include "sopnamsp.h"
#include "pisysdep.h"
#include "pifontmac.h"
#include PIWDG_H

#include "UDrawingState.h"

/* --Methode-- */
PIFontMac::PIFontMac(PIFontName fn)
  : PIFontGen(fn)
{
  SelectFont(fn, PI_RomanFont, PI_NormalSizeFont);
}

/* --Methode-- */
PIFontMac::PIFontMac(int npt, PIFontName fn, PIFontAtt fa)
  : PIFontGen(npt, fn, fa)
{
  SelectFontPt(fn, fa, npt);
}

/* --Methode-- */
PIFontMac::PIFontMac(PIFontMac const & fnt)
  : PIFontGen(fnt.mFName)
{
  SelectFontPt(fnt.mFName, fnt.mFAtt, fnt.mFSize);
}

/* --Methode-- */
PIFontMac::~PIFontMac()
{
}

/* --Methode-- */
PIFontMac & PIFontMac::operator = (PIFontMac const & fnt)
{
  SelectFontPt(fnt.mFName, fnt.mFAtt, fnt.mFSize);
  return(*this);
}

/* --Methode-- */
bool PIFontMac::operator == (PIFontMac const & fnt)
{
  if ((fnt.mFName == mFName) && (fnt.mFAtt == mFAtt) && (fnt.mFSize == mFSize)) 
    return(true);
  else 
    return(false);
}

/* --Methode-- */
void PIFontMac::SetFont(PIFontName fn)
{
  SelectFontPt(fn, mFAtt, mFSize);
}

/* --Methode-- */
void PIFontMac::SetFontAtt(PIFontAtt fa)
{
  SelectFontPt(mFName, fa, mFSize);
}

/* --Methode-- */
void PIFontMac::SetFontSz(PIFontSize fs)
{
  SelectFont(mFName, mFAtt, fs);
}

/* --Methode-- */
void PIFontMac::SetFontSzPt(int npt)
{
  SelectFontPt(mFName, mFAtt, npt);
}

/* --Methode-- */
PIFontName PIFontMac::GetFontName()
{
  return(mFName);
}

/* --Methode-- */
PIFontAtt PIFontMac::GetFontAtt()
{
  return(mFAtt);
}

/* --Methode-- */
int PIFontMac::GetFontSize()
{
  return(mFSize);
}

/* --Methode-- */
void PIFontMac::Apply()
{
  ::TextFont(mFNum);
  ::TextSize(mFSize);
  ::TextFace(mFStyle);
}

/* --Methode-- */
int PIFontMac::GetFontHeight(int& asc, int& desc)
{
  StTextState saver;
  Apply();
  ::FontInfo finfo;
  GetFontInfo(&finfo);
  asc = finfo.ascent;
  desc = finfo.descent;
  return(asc+desc);
}

/* --Methode-- */
int PIFontMac::GetStringWidth(char const* s)
{
  StTextState saver;
  Apply();
  return(::TextWidth(s, 0, strlen(s)));
}


#define NMAXFONTSZ    7
#define NMAXFONTATT   3
#define NMAXFONTTYP   5

/*  Variables globales pour la gestion des fontes  */
static const int fontSizes[4] = {8,12,18,24};

/* --Methode-- */
void PIFontMac::SelectFont(PIFontName fn, PIFontAtt fa, PIFontSize fs)
{
  if (fs < 0 || fs >=4) fs = PI_NormalSizeFont;
  int isz = fontSizes[fs];
  SelectFontPt(fn, fa, isz);
}

/* --Methode-- */
void PIFontMac::SelectFontPt(PIFontName fn, PIFontAtt fa, int npt)
{
  if ((fn == mFName) && (fa == mFAtt) && (npt == mFSize)) return;
  mFName = fn;
  mFAtt  = fa;
  mFSize = npt;
  
  switch (fa) {
    case PI_RomanFont :
      mFStyle = 0;
      break;
    case PI_BoldFont :
      mFStyle = bold;
      break;
    case PI_ItalicFont :
      mFStyle = italic;
      break;
    default :
      mFStyle = 0;
      break;
  }

  switch (fn) {
	  case PI_DefaultFont :
	    mFNum = 0;
	    break;
	  case PI_CourierFont :
	    GetFNum("\pCourier", &mFNum);
	    break;
	  case PI_HelveticaFont :
	    GetFNum("\pHelvetica", &mFNum);
	    break;
	  case PI_TimesFont :
	    GetFNum("\pTimes", &mFNum);
	    break;
	  case PI_SymbolFont :
	    GetFNum("\pSymbol", &mFNum);
	    break;
	  default :
	    mFNum = 0;
	    break;
  }
}

