// Module PI : Peida Interactive     PIMenu
// Menu                                     96-97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "sopnamsp.h"
#include "pimenugen.h"

//++
// Class	PIMenu
// Lib		PI
// include	pimenugen.h
//
//	Composant graphique de type menu. 
//	"PIMenuGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PIMenu" dclare dans le fichier
//	entte "PIMENUBAR_H". Lors de la slction d'une des options du menu
//	Le message correspondant complt par "PIMsg_Click" est envoy  l'objet
//	par "SendSelf()".
//--
//++
// Links	Parents
// PIWdg
//--
//++
// Links	Voir aussi
// PIMenubar
//--



//++
// Titre	Constructeur
//--
//++
// PIMenu(PIWdg* par, const char* nom, PIMenuType pdpu=k_UTMenu)
//	Cration d'un objet Menubar. "pdpu" peut prendre les valeurs
//	"k_UTMenu", "k_PopupMenu", "k_PulldownMenu". Un menu de type
//	"PulldownMenu" est destin  tre accroch  un Menubar ou
//	comme sous-menu d'un autre menu. Si l'objet parent est de type
//	"PIMenu" ou "PIMenubar", un PulldownMenu est cr par dfaut. Un 
//	menu de type PopupMenu est cr dans les autres cas.
// PIMenuType MType() 
//	Renvoie le type du menu : "k_PopupMenu" ou  "k_PulldownMenu".
//--

//++
// Titre	Ajout et suppression des options du menu
//--
//
//++
// void  AppendItem(const char* nom, PIMessage msg, char* sc=NULL)
//	Permet d'ajouter une option au menu. Un raccourci clavier peut tre spcifi
//	par "sc".
// void  AppendCheckItem(const char* nom, PIMessage msg, char* sc=NULL)
//	Permet d'ajouter une option avec tat ON/OFF au menu.
// void	 AppendPDMenu(PIMenu* pdm, char* sc=NULL)
//	Ajoute un menu droulant comme sous-menu.
// void  DeleteItem(const char* nom)
//	Permet de supprimer une option du menu identifie par le titre ("nom").
//	Si le nom dsigne un menu droulant, celui-ci n'est pas dtruit (par "delete").
// void  DeleteItemMsg(PIMessage msg)
//	Permet de supprimer une option du menu identifie par le message ("msg").
// void  DeleteItemNum(int n)
//	Suppression de l'option numro "n".
//--
//++
// Titre	Gestion des options 
//--
//++
// void  SetSensitivity(const char* nom, bool sens=true)
//	Rend sensible ("sens=true") ou insensible l'option du menu identifie par "nom".
//	Une option insensible est affiche, mais ne peut tre slectionne.
// void  SetSensitivityMsg(PIMessage msg, bool sens=true)
//	Rend sensible ("sens=true") ou insensible l'option du menu identifie par le message "msg".
// void  SetSensitivityNum(int n, bool sens=true)
//	Rend sensible ("sens=true") ou insensible l'option numro "n".
// bool  IsSensitive(const char* nom)
//	Indique si l'option "nom" est sensible ou pas.
// bool  IsSensitiveMsg(PIMessage msg)
//	Indique si l'option identifie par le message "msg" est sensible ou pas.
// bool  IsSensitiveNum(int n)
//	Indique si l'option numro "n" est sensible ou pas.
//--
//++
// Titre	Options  tat (CheckItem)
//	Le champ "data" de "Send()/SendSelf()" contient un pointeur sur une variable
//	de type bool, indiquant l'tat (On/Off) de l'option, lors de la slction des
//	options  tat ("CheckItem"). Les mthodes suivantes ne s'appliquent qu'aux 
//	options de type CheckItem.
//--
//++
// void  SetState(const char* nom, bool st=false)
//	Change l'tat de l'option "nom".
// void  SetStateMsg(PIMessage msg, bool st=false)
//	Change l'tat de l'option identifie par le message "msg".
// void  SetStateNum(int n, bool st=false)
//	Change l'tat de l'option numro "n".
// bool GetState(const char* nom)
//	Renvoie l'tat de l'option "nom".
// bool GetStateMsg(PIMessage msg)
//	Renvoie l'tat de l'option identifie par le message "msg".
// bool GetStateNum(int n)
//	Renvoie l'tat de l'option numro "n".
//--

//++
// Titre	Affichage des PopupMenu
//--
//++
// void  Show()
//	Affiche le menu (de type "k_PopupMenu" uniquement)  la position courante du pointeur.
// void  Show(PIWdg* w, int px, int py)
//	Affiche le menu (de type "k_PopupMenu" uniquement)  la position "px,py" de l'objet "w". 
//--

PIMenuGen::PIMenuGen(PIWdg* par, const char* nom, PIMenuType pdpu)
: PIWdg(NULL, nom) , mMTyp(pdpu)
{
SetMsgParent(par);
}

PIMenuGen::~PIMenuGen()
{}

