//  Classe de gestionnaire de message pour programme graphique interactive
//
//                  E.Aubourg , R. Ansari  01-06/96
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "sopnamsp.h"
#include "pimsghandler.h"

//++
// Class	PIMsgHandler
// Lib		PI
// include	pimsghandler.h
//
//   	Classe de gestionnaire de message de Peida Interactive (PI)
//	Les message ("PIMessage") sont des entiers non signs
//	("unsigned long"). 
//	Chaque PIMsgHandler se trouve dans une organisation 
//	hirarchique o il dpend d'un
//	PIMsgHandler pre  qui il reporte les messages, et peut
//	avoir lui-mme un ou plusieurs PIMsgHandler qui sont sous sa 
//	dpendance. Un message ("PIMessage") est constitu de deux 
//	parties, une partie  la disposition de l'utilisateur ("UserMsg()")
//	et une partie sous contrle du code PI ("ModMsg()"), 
//	qui peut spcifie si ncssaire la raison de dclenchement 
//	d'envoi du message. 
//--

//++
// Titre	Constructeur
//--
//++
// PIMsgHandler(PIMsgHandler* par=NULL)
//	Cration d'un PIMsgHandler dpendant hirarchiquement du parent "par"
//--

PIMsgHandler::PIMsgHandler(PIMsgHandler* par)
: msgParent(par)
{}

PIMsgHandler::~PIMsgHandler()
{}


//++
// Titre	Traitement des messages
//--

//++
// PIMessage  UserMsg(PIMessage msg)
//	Dcode et renvoie la partie utilisateur d'un PIMessage
// PIMessage  ModMsg(PIMessage msg)
//	Dcode et renvoie la partie *modifier* d'un PIMessage
// PIMessage  BuildMsg(PIMessage um, PIMsgMod mm) 
//	Code les deux parties (user "um", modifier "mm") d'un message
//	dans un PIMessage.
// void  SetMsgParent(PIMsgHandler* par)
//	Modifie l'organisation hirarchique, en assignant un nouveau pre.
// void	 Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL)
//	Cette mthode virtuelle est appele quand un message "msg"
//	est reue par l'objet gestionnaire. "sender" est l'expditeur
//	du message, et "data" est un argument optionnel supplmentaire.
//	La signification et contenu de "data" dpend de l'expditeur
//	et du contexte. Par dfaut, la mthode "Process(...)" renvoie
//	le message au PIMsgHandler pre, sans altrer l'identit
//	de l'expditeur. (mthode "ReSend(...)"). C'est une mthode 
//	non public (protected) destine tre redfinie par les classes
//	hritires.
// void  Send(PIMessage msg, PIMsgMod mm=0, void* data=NULL)
//	Envoie le message "msg" avec le modifier "mm", et l'argument 
//	optionnel "data" au parent, dclenchant ainsi l'execution
//	de la mthode "Process(...)" du pre.
// void  SendSelf(PIMessage msg, PIMsgMod mm=0, void* data=NULL)
//	Envoie le message "msg" avec le modifier "mm", et l'argument 
//	optionnel "data"  l'objet lui-mme, dclenchant ainsi l'execution
//	de la mthode "Process(...)" de l'objet.
//--

void
PIMsgHandler::Process(PIMessage msg, PIMsgHandler* sender, void* data)
{
	ReSend(msg, sender, data);
}

void
PIMsgHandler::Send(PIMessage msg, PIMsgMod mm,  void* data)
{
//	Process(msg, this, data);  $CHECK$  Reza 12/06/96
// Send par defaut appelle le process du parent $CHECK$
if (msgParent)
  msgParent->Process(BuildMsg(msg, mm), this, data);

}

void
PIMsgHandler::ReSend(PIMessage msg, PIMsgHandler* sender, void* data)
{
  if (msgParent)
    msgParent->Process(msg, sender, data);
}



