#include "sopnamsp.h"
#include "pioptmenumac.h"
#include "pippoptmenu.h"

/* --Methode-- */
PIOptMenuMac::PIOptMenuMac(PIContainerGen* par, char const* nom,
                     int sx, int sy, int px, int py)
: PIOptMenuGen(par, nom, sx, sy, px, py)
{
  delete mPane;
  
  char buff[128];
  strncpy(buff, nom, 64);
  strcat(buff,"_Menu");
  mMen = new PIMenu((PIWdg*)par, buff, k_PopupMenu);
  mMen->SetMsgParent(this);
  LStr255 titre("");
  
  StTextState textState;
  ::TextFont(systemFont);
  ::TextSize(12);
  ::TextFace(0);
  int titleWidth = ::StringWidth(titre);
  
  mPane = new PIPPOptMenu(mPaneInfo, msg_Click, 0, 200, titleWidth+5, popupMenuProc/*+popupVariableWidth*/, 130, titre, 0, 1);
  
  ((PIPPOptMenu*)mPane)->SetMenu(mMen);
  ((LStdPopupMenu*)mPane)->AddListener(this);
  
  Manage();
}

/* --Methode-- */
PIOptMenuMac::~PIOptMenuMac()
{
  delete mMen;
}

/* --Methode-- */
void PIOptMenuMac::Process(PIMessage msg, PIMsgHandler* sender, void* data)
{
if (sender == mMen)   {
  SetValue(UserMsg(msg));
  ReSend(msg, this, NULL);
}
return;
}

void
PIOptMenuMac::ListenToMessage(MessageT /*inMessage*/, void *)
{
//  if (inMessage == msg_Click)
  int n = ((LStdPopupMenu*)mPane)->GetValue()-1;
  mMen->ItemSelected(n);
  mStext = mMen->GetMenuItemText(n);
  mSmsg  = mMen->GetMenuItemMsg(n);
}

/* --Methode-- */
void PIOptMenuMac::SetValueStr(string & s)
{
  int n;
  n=mMen->GetItemNum((char *)s.c_str());
  if (n < 0)  return;  

  StopListening();
  ((LStdPopupMenu*)mPane)->SetValue(n+1);
  StartListening();
  mStext = s;
  mSmsg  = mMen->GetMenuItemMsg(n);
}

/* --Methode-- */
void PIOptMenuMac::SetValue(PIMessage msg)
{
  int n;
  n=mMen->GetItemNumMsg(msg);
  if (n < 0)  return;
  
  StopListening();
  ((LStdPopupMenu*)mPane)->SetValue(n+1);
  StartListening();
  mStext = mMen->GetMenuItemText(n);
  mSmsg  = msg;
}

