#include "sopnamsp.h"
#include "pipplist.h"
#include <LTableMonoGeometry.h>
#include <LTableSingleSelector.h>
#include <LTableMultiSelector.h>
#include <LTableArrayStorage.h>
#include <LComparator.h>

class CellMsgComparator : public LComparator {
public:
	virtual Int32		Compare(
								const void*			inItemOne,
								const void* 		inItemTwo,
								Uint32				/*inSizeOne*/,
								Uint32				/*inSizeTwo*/) const
	{return ((PIPPListCell*)inItemOne)->msg == ((PIPPListCell*)inItemTwo)->msg;}
};

static CellMsgComparator cellMsgComparator;

class CellStrComparator : public LComparator {
public:
	virtual Int32		Compare(
								const void*			inItemOne,
								const void* 		inItemTwo,
								Uint32				/*inSizeOne*/,
								Uint32				/*inSizeTwo*/) const
	{return ((PIPPListCell*)inItemOne)->str == ((PIPPListCell*)inItemTwo)->str;}
};

static CellStrComparator cellStrComparator;


PIPPList::PIPPList(PIMsgHandler* h)
: mHndl(h)
{
  InitPPList();
}

PIPPList::PIPPList(
    const SPaneInfo& inPaneInfo,
    const SViewInfo& inViewInfo,
    PIMsgHandler* h)
: LTableView(inPaneInfo, inViewInfo), mHndl(h)
{
  InitPPList();
}

void PIPPList::InitPPList()
{
  SetTableGeometry(new LTableMonoGeometry(this, 10, 16));
  SetTableSelector(tss=new LTableSingleSelector(this)); 
  mArray = new LArray(sizeof(PIPPListCell)),
  SetTableStorage(new LTableArrayStorage(this, mArray));
  tms = new LTableMultiSelector(this);
  LTableView::InsertCols(1, 0, nil, 0, Refresh_No);
}

PIPPList::~PIPPList()
{
  SetTableSelector(nil);
  delete tss;
  delete tms;
}


void PIPPList::AppendItem(string const& str, PIMessage msg)
{
  PIPPListCell cell;
  cell.str=str;
  cell.msg=msg;
  InsertRows(1, -1, &cell, sizeof(cell), Refresh_Yes);
}

STableCell PIPPList::FindStr(string const& str)
{
  PIPPListCell cell;
  cell.str = str;
  cell.msg = 0;
  mArray->SetComparator(&cellStrComparator);
  STableCell tcell;
  FindCellData(tcell, &cell, sizeof(cell));
  return tcell;
}

STableCell PIPPList::FindMsg(PIMessage msg)
{
  PIPPListCell cell;
  cell.str = "";
  cell.msg = msg;
  mArray->SetComparator(&cellMsgComparator);
  STableCell tcell;
  FindCellData(tcell, &cell, sizeof(cell));
  return tcell;
}

void PIPPList::DeleteItem(string const& str)
{
  STableCell tcell = FindStr(str);
  RemoveRows(1, tcell.row, Refresh_Yes);
}

void PIPPList::DeleteItem(PIMessage msg)
{
  STableCell tcell = FindMsg(msg);
  RemoveRows(1, tcell.row, Refresh_Yes);
}


void PIPPList::SetMultipleSelect(bool ms);
  
int PIPPList::GetNbSel()
{
  int n = 0;
  for (TableIndexT j=1; j<=mRows; j++) {
    STableCell cell;
    cell.row = j;
    cell.col = 1;
    if (CellIsSelected(cell)) n++;
  }
  return n; 
}

PIMessage PIPPList::GetSelMsg(int i)
{
  int n = 0;
  for (TableIndexT j=1; j<=mRows; j++) {
    STableCell cell;
    cell.row = j;
    cell.col = 1;
    if (CellIsSelected(cell)) n++;
    if (n == i) {
       PIPPListCell ppcell;
       UInt32 sz = sizeof(ppcell);
       GetCellData(cell, &ppcell, sz);
       return ppcell.msg;
    }
  }
  return 0; 
}

string PIPPList::GetSelStr(int i)
{
  int n = 0;
  for (TableIndexT j=1; j<=mRows; j++) {
    STableCell cell;
    cell.row = j;
    cell.col = 1;
    if (CellIsSelected(cell)) n++;
    if (n == i) {
       PIPPListCell ppcell;
       UInt32 sz = sizeof(ppcell);
       GetCellData(cell, &ppcell, sz);
       return ppcell.str;
    }
  }
  return ""; 
}
void PIPPList::SelectItem(string const& str)
{
  STableCell cell = FindStr(str);
  SelectCell(cell);
}

void PIPPList::SelectItem(PIMessage msg)
{
  STableCell cell = FindMsg(msg);
  SelectCell(cell);
}

void PIPPList::ClearSelItem(string const& str)
{
  STableCell cell = FindStr(str);
  UnselectCell(cell);
}

void PIPPList::ClearSelItem(PIMessage msg)
{
  STableCell cell = FindMsg(msg);
  UnselectCell(cell);
}

void PIPPList::SetMultipleSelect(bool ms)
{
  if (ms)
    SetTableSelector(tms);
  else
    SetTableSelector(tss); 
}

void
PIPPList::ClickCell(
	const STableCell&		inCell,
	const SMouseDownEvent&	inMouseDown)
{
  if (GetClickCount() == 2) {
	
  }
}
