#include "sopnamsp.h"
#include "pippoptmenu.h"

PIPPOptMenu::PIPPOptMenu(
	const SPaneInfo	&inPaneInfo,
	MessageT		inValueMessage,
	Int16			inTitleOptions,
	ResIDT			inMENUid,
	Int16			inTitleWidth,
	Int16			inPopupVariation,
	ResIDT			inTextTraitsID,
	Str255			inTitle,
	OSType			inResTypeMENU,
	Int16			inInitialMenuItem)
		: LStdPopupMenu(inPaneInfo, inValueMessage, inTitleOptions,
				inMENUid, inTitleWidth, inPopupVariation, inTextTraitsID,
				inTitle, inResTypeMENU, inInitialMenuItem)
{
}



PIPPOptMenu::PIPPOptMenu(
	const SPaneInfo	&inPaneInfo,
	MessageT		inValueMessage,
	Int32			inMaxValue,
	ResIDT			inTextTraitsID,
	ControlHandle	inMacControlH)
		: LStdPopupMenu(inPaneInfo, inValueMessage, inMaxValue,
						inTextTraitsID, inMacControlH)
{
}



PIPPOptMenu::PIPPOptMenu(
	LStream	*inStream)
		: LStdPopupMenu(inStream)
{	
}

void
PIPPOptMenu::HotSpotResult(
	Int16	inHotSpot)
{
		BroadcastMessage(msg_ThumbDragged, (void*) this);
}

void
PIPPOptMenu::SetMenu(PIMenu* pdm)
{
  // On va changer la resource de menu au passage...
  InsertMenu(pdm->GetMacMenuHandle(), hierMenu);
  PopupPrivateDataHandle	dataH =
		(PopupPrivateDataHandle) (**GetMacControl()).contrlData;
  (**dataH).mHandle = pdm->GetMacMenuHandle();
  (**dataH).mID = pdm->GetMacMenuID();
  
  //InitStdPopupMenu(1);
  
  mValue = 1;
  mMinValue = 1;
  mMaxValue = ::CountMItems(pdm->GetMacMenuHandle());

  ::SetControlValue(mMacControlH, mValue);
  ::SetControlMinimum(mMacControlH, mMinValue);
  ::SetControlMaximum(mMacControlH, mMaxValue);
}
