// Module PI : Peida Interactive PISurfaceDrawer
// Drawer et DrawWidget 3D       R. Ansari 06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PISURFDRW_H_SEEN
#define PISURFDRW_H_SEEN

#include "parradapter.h"
#include "pi3ddrw.h"

// Trace d une surface defini par Z=f(x,y)  travers un tableau 
class PISurfaceDrawer : public PIDrawer3D {
public :
  			PISurfaceDrawer(P2DArrayAdapter* arr, bool asxy=false, bool asz=true, bool ad = true);
  			~PISurfaceDrawer();

  virtual void 		UpdateLimits();   // Calcule et change la vue-3D

  virtual void 		Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax); 

/* --- Juin 2004 : decodage des options mis ds PIDrawer3D 
//   Methode de decodage des options
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);
  virtual int        OptionToString(vector<string> & opt) const;
//   Texte d'aide des options disponibles
  virtual void       GetOptionsHelpInfo(string& info);
  ---------     */

protected :
  P2DArrayAdapter* mArr;
  bool mAda;
  double mXmin, mXmax;
  double mYmin, mYmax;
  double mZmin, mZmax;
  LUT* mLut;
};

#endif
