#include "sopnamsp.h"
#include "piwdgmac.h"
#include "pisysdep.h"

#include PICONT_H

#include <LView.h>
#include <LString.h>

void PIBeep()
{
  ::SysBeep(1);
}


PIWdgMac::PIWdgMac(PIContainerGen *par, char *nom,
                   int sx, int sy, int px, int py)
:PIWdgGen(par, nom, sx, sy, px, py), mNom(nom)
{
  mAdapterPaneInfo.paneID    = 0;
  mAdapterPaneInfo.width     = sx;
  mAdapterPaneInfo.height    = sy;
  mAdapterPaneInfo.visible   = true;
  mAdapterPaneInfo.enabled   = true;
  mAdapterPaneInfo.bindings.left =
    mAdapterPaneInfo.bindings.top =
    mAdapterPaneInfo.bindings.right =
    mAdapterPaneInfo.bindings.bottom = false;
  mAdapterPaneInfo.left      = px;
  mAdapterPaneInfo.top       = py;
  mAdapterPaneInfo.userCon   = 0;
  mAdapterPaneInfo.superView = par ? (LView*) (((PIContainerMac*)(par))->mPane) : NULL;

  mAdapterViewInfo.imageSize.width = sx;
  mAdapterViewInfo.imageSize.height = sy;
  mAdapterViewInfo.scrollPos.h = 
    mAdapterViewInfo.scrollPos.v = 
    mAdapterViewInfo.scrollUnit.h = 
    mAdapterViewInfo.scrollUnit.v = 0;
  mAdapterViewInfo.reconcileOverhang = 0;

  mAdapter = new PIPPViewAdapter(mAdapterPaneInfo, mAdapterViewInfo);

  mPaneInfo.paneID    = 'PIWD';
  mPaneInfo.width     = sx;
  mPaneInfo.height    = sy;
  mPaneInfo.visible   = true;
  mPaneInfo.enabled   = true;
  mPaneInfo.bindings.left =
    mPaneInfo.bindings.top =
    mPaneInfo.bindings.right =
    mPaneInfo.bindings.bottom = true;
  mPaneInfo.left      = 0;
  mPaneInfo.top       = 0;
  mPaneInfo.userCon   = 'PIWD';
  mPaneInfo.superView = mAdapter;

  mViewInfo.imageSize.width = sx;
  mViewInfo.imageSize.height = sy;
  mViewInfo.scrollPos.h = 
    mViewInfo.scrollPos.v = 
    mViewInfo.scrollUnit.h = 
    mViewInfo.scrollUnit.v = 0;
  mViewInfo.reconcileOverhang = 0;
  
  mPane = new LView(mPaneInfo, mViewInfo);
  ((LView*)mAdapter)->CalcPortOrigin();
  ((LView*)mPane)->CalcPortOrigin();
}


PIWdgMac::~PIWdgMac()
{
  delete mPane;
  delete mAdapter;
}

void
PIWdgMac::FinishCreate()
{
  mPane->FinishCreate();
}

void
PIWdgMac::ListenToMessage(MessageT /*inMessage*/, void */*ioParam*/)
{

}

void
PIWdgMac::SetLabel(string const& lab)
{
  LStr255 titre(lab.c_str());
  mPane->SetDescriptor(titre);
}

void
PIWdgMac::SetSize(int sx, int sy)
{
  if (mAdapter)
   mAdapter->ResizeFrameTo(sx, sy, true);
  else
   mPane->ResizeFrameTo(sx, sy, true);
}

void
PIWdgMac::SetPos(int px, int py)
{
  if (mAdapter)
   mAdapter->MoveBy(px-XPos(), py-YPos(), false);
  else
   mPane->MoveBy(px-XPos(), py-YPos(), false);
}

void
PIWdgMac::SetBinding(PIBindingKind left, PIBindingKind top, 
                     PIBindingKind right, PIBindingKind bottom)
{
  if (mAdapter)  
    mAdapter->SetBinding(left, top, right, bottom);
  //else
  //  mPane->SetBinding(left, top, right, bottom);
}

bool
PIWdgMac::GetBinding(PIBindingKind& left, PIBindingKind& top, 
                     PIBindingKind& right, PIBindingKind& bottom)
{
  if (mAdapter)  
    mAdapter->GetBinding(left, top, right, bottom);
  //else
  //  mPane->SetBinding(left, top, right, bottom);
  return false;
}

void PIWdgMac::Refresh()
{
  if (mPane) mPane->Refresh();
  if (mAdapter) mAdapter->Refresh();
}


int
PIWdgMac::XSize()
{ 
  SDimension16 outSize;
  mPane->GetFrameSize(outSize);
  return outSize.width;
}

int
PIWdgMac::YSize()
{ 
  SDimension16 outSize;
  mPane->GetFrameSize(outSize);
  return outSize.height;
}

int
PIWdgMac::XPos()
{
  SPoint32 p;
  mPane->GetFrameLocation(p);
  return p.h;
}

int
PIWdgMac::YPos()
{
  SPoint32 p;
  mPane->GetFrameLocation(p);
  return p.v;
}


bool 
PIWdgMac::IsVisible()    // $CHECK$  REZA a verifier  01/12/97
{
if (mPane->IsVisible())  return(true);
else return(false);
}


// Gestion de Copier/Coller
#include <LClipboard.h>
/* --Methode-- */
// COPY
bool PIWdgMac::ClaimSelection(unsigned int)
{
  unsigned int l;
  char* txt = SelectionString(l);
  LClipboard::GetClipboard()->SetData('TEXT',txt,l,true);
  delete[] txt;
  return (true);
}

/* --Methode-- */
void PIWdgMac::SelectionLost()
{
}

/* --Methode-- */
// PASTE
unsigned int PIWdgMac::RequestSelection(unsigned int)
{
  Handle h = NewHandle(0);
  Int32 l = LClipboard::GetClipboard()->GetData('TEXT', h);
  if (l) {
    CopyFromSelection(*h, l);
  }
  return 1;
}

/* --Methode-- */
void PIWdgMac::CopyFromSelection(char * sv, int l)
{
char* buff = new char[l+2];
strncpy(buff, sv, l);
buff[l] = '\0';
printf("PIWdgMac::RequestSelection() L=%d [%s] \n", l, buff);
delete buff;
return;
}

/* --Methode-- */
void PIWdgMac::PasteSelection(unsigned int, void *buff, unsigned int l)
{
  CopyFromSelection((char*) buff, l);
}

/* --Methode-- */
char* PIWdgMac::SelectionString(unsigned int& len)
{
char *rs = new char[60];
strcpy(rs, "Test-of-PIWdgMac::SelectionString()");
len = strlen(rs);
return(rs);
}


/* --Methode-- */
void* PIWdgMac::ProvideSelection(unsigned int&, unsigned int& len)
{
  return SelectionString(len);
}

/* --Methode-- */
void PIWdgMac::SelectionTransferEnd()
{
}

/* --Methode-- */
void PIWdgMac::Manage()
{
  if (mAdapter) mAdapter->Show();
  mPane->Show();
}

/* --Methode-- */
void PIWdgMac::UnManage()
{
  mPane->Hide();
  if (mAdapter) mAdapter->Hide();
}

/* --Methode-- */
bool PIWdgMac::IfManaged()
{
  return(mPane->IsVisible());
}


// -------- La classe PIScreenBuffer ----------
/* --Methode-- */
PIScreenBuffer::PIScreenBuffer(int sx, int sy)
{
  if (sx < 1) sx = 1;
  if (sy < 1) sy = 1;
  Rect bounds = {0,0,sy,sx};
  mGWorld = new LGWorld(bounds);
}
/* --Methode-- */
PIScreenBuffer::~PIScreenBuffer()
{
  delete mGWorld; 
}

/* --Methode-- */
int PIScreenBuffer::XSize()
{
  Rect bounds;
  mGWorld->GetBounds(bounds);
  return bounds.right - bounds.left;
}

/* --Methode-- */
int PIScreenBuffer::YSize()
{
  Rect bounds;
  mGWorld->GetBounds(bounds);
  return bounds.bottom - bounds.top;
}

/* --Methode-- */
void PIScreenBuffer::CopyFromWdg(PIWdg* wdg, int ox, int oy, int dx, int dy, int x, int y)
{
  mGWorld->BeginDrawing();
  LPane* pane = wdg->GetPane();
  Rect srcRect = {oy, ox, oy+dy, ox+dx};
  Rect destRect = {y, x, y+dy, x+dx};
  CopyBits(&pane->GetMacPort()->portBits,&GrafPtr(mGWorld->GetMacGWorld())->portBits,&srcRect,&destRect,srcCopy,NULL);
  mGWorld->EndDrawing();
}

/* --Methode-- */
void PIScreenBuffer::CopyToWdg(PIWdg* wdg, int ox, int oy, int dx, int dy, int x, int y)
{
  LPane* pane = wdg->GetPane();
  Rect srcRect = {oy, ox, oy+dy, ox+dx};
  Rect destRect = {y, x, y+dy, x+dx};
  CopyBits(&GrafPtr(mGWorld->GetMacGWorld())->portBits,&pane->GetMacPort()->portBits,&srcRect,&destRect,srcCopy,NULL);
}

/* --Methode-- */
void PIScreenBuffer::CopyFrom(PIScreenBuffer* grb, int ox, int oy, int dx, int dy, int x, int y)
{

  mGWorld->BeginDrawing();
  Rect srcRect = {oy, ox, oy+dy, ox+dx};
  Rect destRect = {y, x, y+dy, x+dx};
  CopyBits(&GrafPtr(grb->mGWorld->GetMacGWorld())->portBits,&GrafPtr(mGWorld->GetMacGWorld())->portBits,&srcRect,&destRect,srcCopy,NULL);
  mGWorld->EndDrawing();
}
